/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.data;

import java.math.BigInteger;
import org.jaudiotagger.audio.asf.data.GUID;
import org.jaudiotagger.audio.asf.data.StreamChunk;
import org.jaudiotagger.audio.asf.util.Utils;

public class VideoStreamChunk
extends StreamChunk {
    private byte[] codecId;
    private long pictureHeight;
    private long pictureWidth;

    public VideoStreamChunk(BigInteger chunkLen) {
        super(GUID.GUID_VIDEOSTREAM, chunkLen);
    }

    public byte[] getCodecId() {
        return this.codecId;
    }

    public String getCodecIdAsString() {
        if (this.getCodecId() != null) {
            return new String(this.getCodecId());
        }
        return "Unknown";
    }

    public long getPictureHeight() {
        return this.pictureHeight;
    }

    public long getPictureWidth() {
        return this.pictureWidth;
    }

    @Override
    public String prettyPrint(String prefix) {
        StringBuffer result = new StringBuffer(super.prettyPrint(prefix));
        result.insert(0, Utils.LINE_SEPARATOR + prefix + "|->VideoStream");
        result.append(prefix + "Video info:" + Utils.LINE_SEPARATOR);
        result.append(prefix + "      |->Width  : " + this.getPictureWidth() + Utils.LINE_SEPARATOR);
        result.append(prefix + "      |->Heigth : " + this.getPictureHeight() + Utils.LINE_SEPARATOR);
        result.append(prefix + "      |->Codec  : " + this.getCodecIdAsString() + Utils.LINE_SEPARATOR);
        return result.toString();
    }

    public void setCodecId(byte[] codecIdentifier) {
        this.codecId = codecIdentifier;
    }

    public void setPictureHeight(long picHeight) {
        this.pictureHeight = picHeight;
    }

    public void setPictureWidth(long picWidth) {
        this.pictureWidth = picWidth;
    }
}

