/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.asf.io;

import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;

public final class RandomAccessFileInputstream
extends InputStream {
    private final RandomAccessFile source;

    public RandomAccessFileInputstream(RandomAccessFile file) {
        if (file == null) {
            throw new NullPointerException();
        }
        this.source = file;
    }

    @Override
    public int read() throws IOException {
        return this.source.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        return this.source.read(b, off, len);
    }

    @Override
    public long skip(long n) throws IOException {
        if (n <= 0L) {
            return 0L;
        }
        while (n > Integer.MAX_VALUE) {
            this.source.skipBytes(Integer.MAX_VALUE);
            n -= Integer.MAX_VALUE;
        }
        return this.source.skipBytes((int)n);
    }
}

