/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.flac;

import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.flac.FlacStreamReader;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockDataPicture;
import org.jaudiotagger.audio.flac.metadatablock.MetadataBlockHeader;
import org.jaudiotagger.tag.InvalidFrameException;
import org.jaudiotagger.tag.flac.FlacTag;
import org.jaudiotagger.tag.vorbiscomment.VorbisCommentReader;
import org.jaudiotagger.tag.vorbiscomment.VorbisCommentTag;

public class FlacTagReader {
    private VorbisCommentReader vorbisCommentReader = new VorbisCommentReader();

    public FlacTag read(RandomAccessFile raf) throws CannotReadException, IOException {
        FlacStreamReader flacStream = new FlacStreamReader(raf);
        flacStream.findStream();
        VorbisCommentTag tag = null;
        ArrayList<MetadataBlockDataPicture> images = new ArrayList<MetadataBlockDataPicture>();
        boolean isLastBlock = false;
        while (!isLastBlock) {
            MetadataBlockHeader mbh = MetadataBlockHeader.readHeader(raf);
            switch (mbh.getBlockType()) {
                case VORBIS_COMMENT: {
                    byte[] commentHeaderRawPacket = new byte[mbh.getDataLength()];
                    raf.read(commentHeaderRawPacket);
                    tag = this.vorbisCommentReader.read(commentHeaderRawPacket, false);
                    break;
                }
                case PICTURE: {
                    try {
                        MetadataBlockDataPicture mbdp = new MetadataBlockDataPicture(mbh, raf);
                        images.add(mbdp);
                    }
                    catch (IOException ioe) {
                    }
                    catch (InvalidFrameException ive) {}
                    break;
                }
                default: {
                    raf.seek(raf.getFilePointer() + (long)mbh.getDataLength());
                }
            }
            isLastBlock = mbh.isLastBlock();
            mbh = null;
        }
        if (tag == null) {
            tag = VorbisCommentTag.createNewTag();
        }
        FlacTag flacTag = new FlacTag(tag, images);
        return flacTag;
    }
}

