/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.generic;

import java.util.HashMap;
import java.util.Set;
import org.jaudiotagger.audio.AudioHeader;

public class GenericAudioHeader
implements AudioHeader {
    public static final String FIELD_BITRATE = "BITRATE";
    public static final String FIELD_CHANNEL = "CHANNB";
    public static final String FIELD_INFOS = "INFOS";
    public static final String FIELD_LENGTH = "LENGTH";
    public static final String FIELD_SAMPLERATE = "SAMPLING";
    public static final String FIELD_TYPE = "TYPE";
    public static final String FIELD_VBR = "VBR";
    public static final String FIELD_AUDIO_START_BYTE = "AUDIO_START_BYTE";
    public static final String FIELD_AUDIO_END_BYTE = "AUDIO_END_BYTE";
    private boolean isLossless = false;
    protected HashMap<String, Object> content = new HashMap(6);

    public GenericAudioHeader() {
        this.content.put(FIELD_BITRATE, new Integer(-1));
        this.content.put(FIELD_CHANNEL, new Integer(-1));
        this.content.put(FIELD_TYPE, "");
        this.content.put(FIELD_INFOS, "");
        this.content.put(FIELD_SAMPLERATE, new Integer(-1));
        this.content.put(FIELD_LENGTH, new Float(-1.0f));
        this.content.put(FIELD_VBR, new Boolean(true));
        this.content.put(FIELD_AUDIO_START_BYTE, new Long(0L));
        this.content.put(FIELD_AUDIO_END_BYTE, new Long(-1L));
    }

    @Override
    public String getBitRate() {
        return ((Integer)this.content.get(FIELD_BITRATE)).toString();
    }

    @Override
    public long getBitRateAsNumber() {
        return ((Integer)this.content.get(FIELD_BITRATE)).longValue();
    }

    public int getChannelNumber() {
        return (Integer)this.content.get(FIELD_CHANNEL);
    }

    @Override
    public String getChannels() {
        return String.valueOf(this.getChannelNumber());
    }

    @Override
    public String getEncodingType() {
        return (String)this.content.get(FIELD_TYPE);
    }

    @Override
    public String getFormat() {
        return (String)this.content.get(FIELD_TYPE);
    }

    public String getExtraEncodingInfos() {
        return (String)this.content.get(FIELD_INFOS);
    }

    @Override
    public int getTrackLength() {
        return (int)this.getPreciseLength();
    }

    public float getPreciseLength() {
        return ((Float)this.content.get(FIELD_LENGTH)).floatValue();
    }

    @Override
    public String getSampleRate() {
        return ((Integer)this.content.get(FIELD_SAMPLERATE)).toString();
    }

    @Override
    public int getSampleRateAsNumber() {
        return (Integer)this.content.get(FIELD_SAMPLERATE);
    }

    @Override
    public long getAudioEndByte() {
        return (Long)this.content.get(FIELD_AUDIO_END_BYTE);
    }

    @Override
    public long getAudioStartByte() {
        return (Long)this.content.get(FIELD_AUDIO_START_BYTE);
    }

    @Override
    public boolean isVariableBitRate() {
        return (Boolean)this.content.get(FIELD_VBR);
    }

    public boolean isLossless() {
        return this.isLossless;
    }

    public void setBitrate(int bitrate) {
        this.content.put(FIELD_BITRATE, new Integer(bitrate));
    }

    public void setChannelNumber(int chanNb) {
        this.content.put(FIELD_CHANNEL, new Integer(chanNb));
    }

    public void setEncodingType(String encodingType) {
        this.content.put(FIELD_TYPE, encodingType);
    }

    public void setExtraEncodingInfos(String infos) {
        this.content.put(FIELD_INFOS, infos);
    }

    public void setLength(int length) {
        this.content.put(FIELD_LENGTH, new Float(length));
    }

    public void setPreciseLength(float seconds) {
        this.content.put(FIELD_LENGTH, new Float(seconds));
    }

    public void setSamplingRate(int samplingRate) {
        this.content.put(FIELD_SAMPLERATE, new Integer(samplingRate));
    }

    public void setVariableBitRate(boolean b) {
        this.content.put(FIELD_VBR, new Boolean(b));
    }

    public void setLossless(boolean b) {
        this.isLossless = b;
    }

    public void setExtra(String key, Object value) {
        this.content.put(key, value);
    }

    public void setAudioEndByte(long value) {
        this.content.put(FIELD_AUDIO_END_BYTE, new Long(value));
    }

    public void setAudioStartByte(long value) {
        this.content.put(FIELD_AUDIO_START_BYTE, new Long(value));
    }

    public String toString() {
        StringBuffer out = new StringBuffer(50);
        out.append("Encoding infos content:\n");
        Set<String> set = this.content.keySet();
        for (String key : set) {
            Object val = this.content.get(key);
            out.append("\t");
            out.append((Object)key);
            out.append(" : ");
            out.append(val);
            out.append("\n");
        }
        return out.toString().substring(0, out.length() - 1);
    }
}

