/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.mp3;

import java.nio.ByteBuffer;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.mp3.MP3AudioHeader;
import org.jaudiotagger.audio.mp3.MPEGFrameHeader;
import org.jaudiotagger.audio.mp3.XingFrame;

public class ByteArrayMP3AudioHeader
extends MP3AudioHeader {
    public ByteArrayMP3AudioHeader(byte[] fileBytes) {
        long filePointerCount = 0L;
        ByteBuffer bb = ByteBuffer.wrap(fileBytes);
        boolean syncFound = false;
        do {
            if (MPEGFrameHeader.isMPEGFrame(bb)) {
                try {
                    this.mp3FrameHeader = MPEGFrameHeader.parseMPEGHeader(bb);
                    syncFound = true;
                    if (XingFrame.isXingFrame(bb, this.mp3FrameHeader)) {
                        try {
                            this.mp3XingFrame = XingFrame.parseXingFrame();
                        }
                        catch (InvalidAudioFrameException ex) {}
                        break;
                    }
                    syncFound = this.isNextFrameValid(bb);
                    if (syncFound) {
                        break;
                    }
                }
                catch (InvalidAudioFrameException ex) {
                    // empty catch block
                }
            }
            bb.position(bb.position() + 1);
            ++filePointerCount;
        } while (!syncFound);
        this.setFileSize(fileBytes.length);
        this.setMp3StartByte(filePointerCount);
        this.setTimePerFrame();
        this.setNumberOfFrames();
        this.setTrackLength();
        this.setBitRate();
        this.setEncoder();
    }

    private boolean isNextFrameValid(ByteBuffer bb) {
        boolean result = false;
        int currentPosition = bb.position();
        bb.position(bb.position() + this.mp3FrameHeader.getFrameLength());
        if (MPEGFrameHeader.isMPEGFrame(bb)) {
            try {
                MPEGFrameHeader.parseMPEGHeader(bb);
                result = true;
            }
            catch (InvalidAudioFrameException ex) {
                result = false;
            }
        }
        bb.position(currentPosition);
        return result;
    }
}

