/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.audio.mp3;

import java.nio.ByteBuffer;
import java.util.Arrays;
import org.jaudiotagger.audio.exceptions.InvalidAudioFrameException;
import org.jaudiotagger.audio.mp3.LameFrame;
import org.jaudiotagger.audio.mp3.MPEGFrameHeader;

public class VbriFrame {
    private static final int VBRI_OFFSET = 36;
    private static final int VBRI_HEADER_BUFFER_SIZE = 120;
    private static final int VBRI_IDENTIFIER_BUFFER_SIZE = 4;
    private static final int VBRI_DELAY_BUFFER_SIZE = 2;
    private static final int VBRI_QUALITY_BUFFER_SIZE = 2;
    private static final int VBRI_AUDIOSIZE_BUFFER_SIZE = 4;
    private static final int VBRI_FRAMECOUNT_BUFFER_SIZE = 4;
    private static final int VBRI_TOC_ENTRY_BUFFER_SIZE = 2;
    public static final int MAX_BUFFER_SIZE_NEEDED_TO_READ_VBRI = 156;
    private static final int BYTE_1 = 0;
    private static final int BYTE_2 = 1;
    private static final int BYTE_3 = 2;
    private static final int BYTE_4 = 3;
    private static final byte[] VBRI_VBR_ID = new byte[]{86, 66, 82, 73};
    private static ByteBuffer header;
    private static VbriFrame VBRIFrame;
    private boolean vbr = false;
    private boolean isFrameCountEnabled = false;
    private int frameCount = -1;
    private boolean isAudioSizeEnabled = false;
    private int audioSize = -1;
    private LameFrame lameFrame;

    private VbriFrame() {
        header.rewind();
        header.position(10);
        this.setAudioSize();
        this.setFrameCount();
    }

    private void setAudioSize() {
        byte[] frameSizeBuffer = new byte[4];
        header.get(frameSizeBuffer);
        this.isAudioSizeEnabled = true;
        this.audioSize = frameSizeBuffer[0] << 24 & 0xFF000000 | frameSizeBuffer[1] << 16 & 0xFF0000 | frameSizeBuffer[2] << 8 & 0xFF00 | frameSizeBuffer[3] & 0xFF;
    }

    private void setFrameCount() {
        byte[] frameCountBuffer = new byte[4];
        header.get(frameCountBuffer);
        this.isFrameCountEnabled = true;
        this.frameCount = frameCountBuffer[0] << 24 & 0xFF000000 | frameCountBuffer[1] << 16 & 0xFF0000 | frameCountBuffer[2] << 8 & 0xFF00 | frameCountBuffer[3] & 0xFF;
    }

    public final int getFrameCount() {
        return this.frameCount;
    }

    public final int getAudioSize() {
        return this.audioSize;
    }

    public static VbriFrame parseVBRIFrame() throws InvalidAudioFrameException {
        VBRIFrame = new VbriFrame();
        return VBRIFrame;
    }

    public static boolean isVbriFrame(ByteBuffer bb, MPEGFrameHeader mpegFrameHeader) {
        int startPosition = bb.position();
        bb.position(startPosition + 36);
        header = bb.slice();
        bb.position(startPosition);
        byte[] identifier = new byte[4];
        header.get(identifier);
        return Arrays.equals(identifier, VBRI_VBR_ID);
    }

    public final boolean isVbr() {
        return true;
    }

    public String getEncoder() {
        return "Fraunhofer";
    }

    public String toString() {
        return "VBRIheader vbr:" + this.vbr + " frameCount:" + this.frameCount + " audioFileSize:" + this.audioSize + " encoder:" + this.getEncoder();
    }

    static {
        VBRIFrame = null;
    }
}

