/*
 * Decompiled with CFR 0.152.
 */
package org.jaudiotagger.tag.vorbiscomment;

import java.io.IOException;
import org.jaudiotagger.audio.exceptions.CannotReadException;
import org.jaudiotagger.audio.generic.Utils;
import org.jaudiotagger.fix.Fix;
import org.jaudiotagger.logging.ErrorMessage;
import org.jaudiotagger.tag.vorbiscomment.VorbisCommentTag;
import org.jaudiotagger.tag.vorbiscomment.VorbisCommentTagField;

public class VorbisCommentReader {
    public static final int FIELD_VENDOR_LENGTH_POS = 0;
    public static final int FIELD_VENDOR_STRING_POS = 4;
    public static final int FIELD_VENDOR_LENGTH_LENGTH = 4;
    public static final int FIELD_USER_COMMENT_LIST_LENGTH = 4;
    public static final int FIELD_COMMENT_LENGTH_LENGTH = 4;
    private Fix fix;

    public VorbisCommentReader() {
    }

    public VorbisCommentReader(Fix fix) {
        this.fix = fix;
    }

    public VorbisCommentTag read(byte[] rawdata, boolean isFramingBit) throws IOException, CannotReadException {
        VorbisCommentTag tag = new VorbisCommentTag();
        byte[] b = new byte[4];
        System.arraycopy(rawdata, 0, b, 0, 4);
        int pos = 4;
        int vendorStringLength = Utils.getIntLE(b);
        b = new byte[vendorStringLength];
        System.arraycopy(rawdata, pos, b, 0, vendorStringLength);
        tag.setVendor(new String(b, "UTF-8"));
        b = new byte[4];
        System.arraycopy(rawdata, pos += vendorStringLength, b, 0, 4);
        pos += 4;
        int userComments = Utils.getIntLE(b);
        if (this.fix == Fix.FIX_OGG_VORBIS_COMMENT_NOT_COUNTING_EMPTY_COLUMNS) {
            ++userComments;
        }
        for (int i = 0; i < userComments; ++i) {
            b = new byte[4];
            System.arraycopy(rawdata, pos, b, 0, 4);
            int commentLength = Utils.getIntLE(b);
            b = new byte[commentLength];
            System.arraycopy(rawdata, pos += 4, b, 0, commentLength);
            pos += commentLength;
            VorbisCommentTagField fieldComment = new VorbisCommentTagField(b);
            tag.add(fieldComment);
        }
        if (isFramingBit && (rawdata[pos] & 1) != 1) {
            throw new CannotReadException(ErrorMessage.OGG_VORBIS_NO_FRAMING_BIT.getMsg(rawdata[pos] & 1));
        }
        return tag;
    }
}

