/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

public final class ApproximateMatcher {
    private boolean ignoreCase = false;
    private boolean ignoreWhitespace = false;
    private boolean compareBackwards = false;
    private volatile int[][] buffer;
    private volatile int bufSize;

    public ApproximateMatcher() {
        this.buffer = null;
    }

    public ApproximateMatcher(int size) {
        this.bufSize = size + 1;
        this.buffer = new int[this.bufSize][this.bufSize];
    }

    public void setIgnoreCase(boolean ignoreCase) {
        this.ignoreCase = ignoreCase;
    }

    public void setIgnoreWhitespace(boolean ignoreWhitespace) {
        this.ignoreWhitespace = ignoreWhitespace;
    }

    public void setCompareBackwards(boolean compareBackwards) {
        this.compareBackwards = compareBackwards;
    }

    public String process(String s) {
        if (!(this.ignoreCase || this.compareBackwards || this.ignoreWhitespace)) {
            return s;
        }
        StringBuilder buf = new StringBuilder(s.length());
        if (this.compareBackwards) {
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(s.length() - i - 1);
                if (this.ignoreCase) {
                    c = Character.toLowerCase(c);
                }
                if (this.ignoreWhitespace && (c == ' ' || c == '_')) continue;
                buf.append(c);
            }
        } else {
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (this.ignoreCase) {
                    c = Character.toLowerCase(c);
                }
                if (this.ignoreWhitespace && (c == ' ' || c == '_')) continue;
                buf.append(c);
            }
        }
        return buf.toString();
    }

    public final int match(String s1, String s2) {
        return this.matchInternal(s1, s2, Integer.MAX_VALUE);
    }

    public final boolean matches(String s1, String s2, int maxOps) {
        return this.matchInternal(s1, s2, maxOps) <= maxOps;
    }

    public final boolean matches(String s1, String s2, float precision) {
        int s1n = s1.length();
        int n = (int)(precision * (float)s1n);
        int maxOps = s1n - n;
        return this.matches(s1, s2, maxOps);
    }

    private int matchInternal(String s1, String s2, int maxOps) {
        if (s1.length() <= s2.length()) {
            return this.matchInternalProcessed(s1, s2, maxOps);
        }
        return this.matchInternalProcessed(s2, s1, maxOps);
    }

    private int matchInternalProcessed(String s1, String s2, int maxOps) {
        int s1n = s1.length();
        int s2n = s2.length();
        assert (s1n <= s2n);
        if (maxOps <= 0) {
            return s1.equals(s2) ? 0 : 1;
        }
        if (Math.abs(s1n - s2n) > maxOps) {
            return maxOps + 1;
        }
        if (s1n == 0) {
            return s2n;
        }
        int[][] d = this.buffer != null && this.bufSize >= Math.max(s1n + 1, s2n + 1) ? this.buffer : new int[s1n + 1][s2n + 1];
        int diagonals = 2 * Math.min(s1n + 1, s2n + 1) - 1 + Math.min(s2n - s1n, maxOps);
        int minLastDiag = 0;
        for (int k = 1; k < diagonals; ++k) {
            boolean innerDiag;
            int i1 = k / 2 + maxOps / 2;
            int j1 = k / 2 - maxOps / 2;
            int i2 = k / 2 - maxOps / 2;
            int j2 = k / 2 + maxOps / 2;
            if (k % 2 != 0) {
                if (maxOps % 2 == 0) {
                    ++j1;
                    ++i2;
                } else {
                    ++i1;
                    ++j2;
                }
            }
            if (j1 < 0 || i1 > s1n) {
                i1 = Math.min(k, s1n);
                j1 = k - i1;
            }
            if (i2 < 0 || j2 > s2n) {
                j2 = Math.min(k, s2n);
                i2 = k - j2;
            }
            assert (i1 > 0) : "Zero i1";
            assert (j2 > 0) : "Zero j2";
            d[i1][j1] = d[i1 - 1][j1] + 1;
            d[i2][j2] = d[i2][j2 - 1] + 1;
            if (j1 > 0) {
                d[i1][j1] = Math.min(d[i1][j1], d[i1 - 1][j1 - 1] + ApproximateMatcher.diff(s1.charAt(i1 - 1), s2.charAt(j1 - 1)));
            }
            if (i2 > 0) {
                d[i2][j2] = Math.min(d[i2][j2], d[i2 - 1][j2 - 1] + ApproximateMatcher.diff(s1.charAt(i2 - 1), s2.charAt(j2 - 1)));
            }
            boolean bl = innerDiag = k % 2 != maxOps % 2;
            if ((innerDiag || i1 == s1n) && j1 > 0) {
                d[i1][j1] = Math.min(d[i1][j1], d[i1][j1 - 1] + 1);
            }
            if (innerDiag && i2 > 0) {
                d[i2][j2] = Math.min(d[i2][j2], d[i2 - 1][j2] + 1);
            }
            int minThisDiag = Math.min(d[i1][j1], d[i2][j2]);
            int i = i1 - 1;
            for (int j = j1 + 1; i > i2 && j < j2; --i, ++j) {
                int dij;
                d[i][j] = 1;
                d[i][j] = dij = ApproximateMatcher.min3(d[i - 1][j - 1] + ApproximateMatcher.diff(s1.charAt(i - 1), s2.charAt(j - 1)), d[i - 1][j] + 1, d[i][j - 1] + 1);
                minThisDiag = Math.min(minThisDiag, dij);
            }
            if (minThisDiag > maxOps && minLastDiag > maxOps) {
                return minThisDiag;
            }
            minLastDiag = minThisDiag;
        }
        return d[s1n][s2n];
    }

    private static int diff(char a, char b) {
        if (a == b) {
            return 0;
        }
        return 1;
    }

    private static int min3(int n1, int n2, int n3) {
        return Math.min(n1, Math.min(n2, n3));
    }
}

