/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.collection;

import java.util.Arrays;
import java.util.Locale;

public class BitNumbers {
    private static final byte[] EMPTY = new byte[0];
    private static final byte[] MASKS = new byte[]{-128, 64, 32, 16, 8, 4, 2, 1};
    private byte[] data;
    private final int size;
    public static final BitNumbers EMPTY_BN = new ImmutableBitNumbers();

    public BitNumbers(byte[] data) {
        this.data = data;
        this.size = data.length * 8;
    }

    public BitNumbers(int size) {
        this.size = size;
    }

    public BitNumbers(String hexString) throws IllegalArgumentException {
        this.data = new byte[(int)Math.ceil((double)hexString.length() / 2.0)];
        this.size = this.data.length * 8;
        for (int i = 0; i < hexString.length(); i += 2) {
            boolean nibble = i == hexString.length() - 1;
            int j = Integer.parseInt(hexString.substring(i, nibble ? i + 1 : i + 2), 16);
            if (nibble) {
                j <<= 4;
            }
            assert (j <= 255);
            this.data[i / 2] = (byte)j;
        }
    }

    public boolean isSet(int idx) {
        if (idx >= this.size) {
            return false;
        }
        int index = (int)Math.floor((double)idx / 8.0);
        int offset = idx % 8;
        return this.data != null && index < this.data.length && (this.data[index] & MASKS[offset]) != 0;
    }

    public int getMax() {
        return this.size;
    }

    public void set(int idx) {
        if (idx >= this.size) {
            throw new IndexOutOfBoundsException("idx: " + idx + ", max: " + this.size);
        }
        int index = (int)Math.floor((double)idx / 8.0);
        int offset = idx % 8;
        if (this.data == null) {
            this.data = new byte[(int)Math.ceil((double)this.size / 8.0)];
        }
        int n = index;
        this.data[n] = (byte)(this.data[n] | MASKS[offset]);
    }

    public byte[] toByteArray() {
        if (this.data == null) {
            return EMPTY;
        }
        int lastNonZero = this.getLastNonZeroIndex();
        if (lastNonZero == -1) {
            return EMPTY;
        }
        if (lastNonZero == this.data.length - 1) {
            return this.data;
        }
        byte[] shortened = new byte[lastNonZero + 1];
        System.arraycopy(this.data, 0, shortened, 0, lastNonZero + 1);
        return shortened;
    }

    public boolean isEmpty() {
        if (this.data == null) {
            return true;
        }
        for (byte b : this.data) {
            if (b == 0) continue;
            return false;
        }
        return true;
    }

    public boolean equals(Object obj) {
        if (obj instanceof BitNumbers) {
            BitNumbers other = (BitNumbers)obj;
            return Arrays.equals(this.toByteArray(), other.toByteArray());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.toByteArray());
    }

    public String toHexString() {
        if (this.isEmpty()) {
            return "";
        }
        StringBuilder sb = new StringBuilder(this.data.length * 2);
        int lastNonZero = 0;
        for (int i = 0; i < this.data.length; ++i) {
            String hex;
            if (this.data[i] != 0) {
                lastNonZero = i;
            }
            if ((hex = Integer.toHexString(this.data[i] & 0xFF)).length() == 1) {
                sb.append("0");
            }
            sb.append(hex.toUpperCase(Locale.US));
        }
        sb.setLength(lastNonZero * 2 + 2);
        if (sb.length() > 1 && sb.charAt(sb.length() - 1) == '0') {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    private int getLastNonZeroIndex() {
        for (int i = this.data.length - 1; i >= 0; --i) {
            if (this.data[i] == 0) continue;
            return i;
        }
        return -1;
    }

    public String toString() {
        return this.toHexString();
    }

    public static BitNumbers synchronizedBitNumbers(BitNumbers delegate) {
        return new SynchronizedBitNumbers(delegate);
    }

    private static class SynchronizedBitNumbers
    extends BitNumbers {
        private final BitNumbers delegate;

        private SynchronizedBitNumbers(BitNumbers delegate) {
            super(0);
            this.delegate = delegate;
        }

        @Override
        public synchronized boolean isEmpty() {
            return this.delegate.isEmpty();
        }

        @Override
        public synchronized int getMax() {
            return this.delegate.getMax();
        }

        @Override
        public synchronized boolean isSet(int idx) {
            return this.delegate.isSet(idx);
        }

        @Override
        public synchronized void set(int idx) {
            this.delegate.set(idx);
        }

        @Override
        public synchronized byte[] toByteArray() {
            return this.delegate.toByteArray();
        }

        @Override
        public synchronized String toHexString() {
            return this.delegate.toHexString();
        }

        @Override
        public synchronized String toString() {
            return this.delegate.toString();
        }
    }

    private static class ImmutableBitNumbers
    extends BitNumbers {
        @Override
        public void set(int idx) {
            throw new UnsupportedOperationException("immutable!");
        }

        ImmutableBitNumbers() {
            super(0);
        }
    }
}

