/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.concurrent;

import java.lang.reflect.UndeclaredThrowableException;
import java.util.Collections;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.Callable;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.limewire.concurrent.AbstractListeningExecutorService;
import org.limewire.concurrent.FutureEvent;
import org.limewire.concurrent.ListeningFutureTask;
import org.limewire.concurrent.RunnableListeningFuture;
import org.limewire.concurrent.ScheduledListeningExecutorService;
import org.limewire.concurrent.ScheduledListeningFuture;
import org.limewire.listener.EventListener;
import org.limewire.service.ErrorService;

public class SimpleTimer
extends AbstractListeningExecutorService
implements ScheduledListeningExecutorService {
    private final Timer TIMER;
    private volatile boolean cancelled = false;

    public SimpleTimer(String name, boolean isDaemon) {
        this.TIMER = new Timer(name, isDaemon);
    }

    public SimpleTimer(boolean isDaemon) {
        this.TIMER = new Timer(isDaemon);
    }

    @Override
    public ScheduledListeningFuture<?> schedule(Runnable command, long delay, TimeUnit unit) {
        ListeningScheduledTimerTask future = new ListeningScheduledTimerTask(command, 0L);
        this.scheduleInternal(future, unit.toMillis(delay), 0L, false);
        return future;
    }

    @Override
    public <V> ScheduledListeningFuture<V> schedule(Callable<V> callable, long delay, TimeUnit unit) {
        ListeningScheduledTimerTask<V> future = new ListeningScheduledTimerTask<V>(callable, 0L);
        this.scheduleInternal(future, unit.toMillis(delay), 0L, false);
        return future;
    }

    @Override
    public ScheduledFuture<?> scheduleAtFixedRate(Runnable command, long initialDelay, long period, TimeUnit unit) {
        ListeningScheduledTimerTask future = new ListeningScheduledTimerTask(command, period);
        this.scheduleInternal(future, unit.toMillis(initialDelay), unit.toMillis(period), true);
        return future;
    }

    @Override
    public ScheduledFuture<?> scheduleWithFixedDelay(Runnable command, long initialDelay, long delay, TimeUnit unit) {
        ListeningScheduledTimerTask future = new ListeningScheduledTimerTask(command, delay);
        this.scheduleInternal(future, unit.toMillis(initialDelay), unit.toMillis(delay), false);
        return future;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) throws InterruptedException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isShutdown() {
        return this.cancelled;
    }

    @Override
    public boolean isTerminated() {
        return this.cancelled;
    }

    @Override
    public void shutdown() {
        this.cancelled = true;
        this.TIMER.cancel();
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shutdown();
        return Collections.emptyList();
    }

    @Override
    public void execute(final Runnable command) {
        TimerTask tt = new TimerTask(){

            @Override
            public void run() {
                try {
                    command.run();
                }
                catch (Throwable t) {
                    ErrorService.error(t);
                }
            }
        };
        this.scheduleInternal(tt, 0L, 0L, false);
    }

    private void scheduleInternal(TimerTask task, long delay, long period, boolean fixedRate) {
        block7: {
            try {
                if (period == 0L) {
                    if (fixedRate) {
                        throw new IllegalArgumentException("cannot support 0 period w/ fixedRate");
                    }
                    this.TIMER.schedule(task, delay);
                } else if (fixedRate) {
                    this.TIMER.scheduleAtFixedRate(task, delay, period);
                } else {
                    this.TIMER.schedule(task, delay, period);
                }
            }
            catch (IllegalStateException ise) {
                if (!this.cancelled) break block7;
                throw ise;
            }
        }
    }

    private static class ListeningResetableFutureTask<V>
    extends ListeningFutureTask<V> {
        private final boolean periodic;

        public ListeningResetableFutureTask(Runnable runnable, V result, boolean periodic) {
            super(runnable, result);
            this.periodic = periodic;
        }

        public ListeningResetableFutureTask(Callable<V> callable, boolean periodic) {
            super(callable);
            this.periodic = periodic;
        }

        @Override
        public void run() {
            if (this.periodic) {
                super.runAndReset();
            } else {
                super.run();
            }
        }
    }

    private static class ListeningScheduledTimerTask<V>
    extends TimerTask
    implements ScheduledListeningFuture<V> {
        private final RunnableListeningFuture<V> task;

        public ListeningScheduledTimerTask(final Runnable r, long period) {
            this.task = new ListeningResetableFutureTask<Object>(new Runnable(){

                @Override
                public void run() {
                    try {
                        r.run();
                    }
                    catch (RuntimeException e) {
                        ErrorService.error(e);
                        throw e;
                    }
                    catch (Error e) {
                        ErrorService.error(e);
                        throw e;
                    }
                    catch (Exception e) {
                        ErrorService.error(e);
                        throw new UndeclaredThrowableException(e);
                    }
                }
            }, null, period != 0L);
        }

        public ListeningScheduledTimerTask(final Callable<V> c, long period) {
            this.task = new ListeningResetableFutureTask(new Callable<V>(){

                @Override
                public V call() {
                    try {
                        return c.call();
                    }
                    catch (RuntimeException e) {
                        ErrorService.error(e);
                        throw e;
                    }
                    catch (Error e) {
                        ErrorService.error(e);
                        throw e;
                    }
                    catch (Exception e) {
                        ErrorService.error(e);
                        throw new UndeclaredThrowableException(e);
                    }
                }
            }, period != 0L);
        }

        @Override
        public void run() {
            this.task.run();
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return -1L;
        }

        @Override
        public int compareTo(Delayed o) {
            return 0;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            this.cancel();
            return this.task.cancel(mayInterruptIfRunning);
        }

        @Override
        public V get() throws InterruptedException, ExecutionException {
            return this.task.get();
        }

        @Override
        public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            return this.task.get(timeout, unit);
        }

        @Override
        public boolean isCancelled() {
            return this.task.isCancelled();
        }

        @Override
        public boolean isDone() {
            return this.task.isDone();
        }

        @Override
        public void addFutureListener(EventListener<FutureEvent<V>> listener) {
            this.task.addFutureListener(listener);
        }
    }
}

