/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl.download.listener;

import com.google.inject.Inject;
import com.google.inject.assistedinject.Assisted;
import com.limegroup.gnutella.Downloader;
import com.limegroup.gnutella.downloader.CoreDownloader;
import com.limegroup.gnutella.downloader.DownloadStateEvent;
import java.io.File;
import org.limewire.core.impl.itunes.ItunesMediator;
import org.limewire.core.settings.iTunesSettings;
import org.limewire.listener.EventListener;
import org.limewire.util.Objects;

public class ItunesDownloadListener
implements EventListener<DownloadStateEvent> {
    private final Downloader downloader;
    private final ItunesMediator itunesMediator;

    @Inject
    public ItunesDownloadListener(@Assisted Downloader downloader, ItunesMediator itunesMediator) {
        this.downloader = Objects.nonNull(downloader, "downloader");
        this.itunesMediator = itunesMediator;
        if (downloader.getState() == Downloader.DownloadState.COMPLETE && downloader instanceof CoreDownloader) {
            this.handleEvent(new DownloadStateEvent((CoreDownloader)downloader, Downloader.DownloadState.COMPLETE));
        }
    }

    @Override
    public void handleEvent(DownloadStateEvent event) {
        File saveFile;
        Downloader.DownloadState downloadStatus = (Downloader.DownloadState)((Object)event.getType());
        if (Downloader.DownloadState.COMPLETE == downloadStatus && (saveFile = this.downloader.getSaveFile()) != null && iTunesSettings.ITUNES_SUPPORT_ENABLED.getValue()) {
            this.itunesMediator.addSong(saveFile);
        }
    }
}

