/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl.library;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.impl.ReadOnlyList;
import ca.odell.glazedlists.util.concurrent.LockFactory;
import ca.odell.glazedlists.util.concurrent.ReadWriteLock;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.limewire.collection.MultiIterable;
import org.limewire.collection.glazedlists.GlazedListsFactory;
import org.limewire.core.api.library.FriendLibrary;
import org.limewire.core.api.library.PresenceLibrary;
import org.limewire.core.api.library.RemoteLibrary;
import org.limewire.core.api.library.RemoteLibraryEvent;
import org.limewire.core.api.library.RemoteLibraryManager;
import org.limewire.core.api.library.RemoteLibraryState;
import org.limewire.core.api.search.SearchResult;
import org.limewire.friend.api.Friend;
import org.limewire.friend.api.FriendPresence;
import org.limewire.inspection.DataCategory;
import org.limewire.inspection.Inspectable;
import org.limewire.inspection.InspectableContainer;
import org.limewire.inspection.InspectionPoint;
import org.limewire.listener.EventListener;
import org.limewire.listener.EventListenerList;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.util.StringUtils;

@Singleton
public class RemoteLibraryManagerImpl
implements RemoteLibraryManager {
    private static final Log LOG = LogFactory.getLog(RemoteLibraryManagerImpl.class, "friend-library");
    private final EventList<FriendLibrary> allFriendLibraries;
    private final EventList<FriendLibrary> readOnlyFriendLibraries;
    private final EventListenerList<RemoteLibraryEvent> listeners = new EventListenerList();
    private final AllFriendsLibraryImpl allFriendsLibrary = new AllFriendsLibraryImpl();
    private final PropagatingEventListener propagatingEventListener = new PropagatingEventListener(this.allFriendsLibrary, this.listeners);
    private final ReadWriteLock listLock = LockFactory.DEFAULT.createReadWriteLock();

    @Inject
    public RemoteLibraryManagerImpl() {
        this.allFriendLibraries = GlazedListsFactory.threadSafeList(new BasicEventList(this.listLock));
        this.readOnlyFriendLibraries = GlazedListsFactory.readOnlyList(this.allFriendLibraries);
    }

    @Override
    public RemoteLibrary getAllFriendsLibrary() {
        return this.allFriendsLibrary;
    }

    @Override
    public EventList<FriendLibrary> getFriendLibraryList() {
        return this.allFriendLibraries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addPresenceLibrary(FriendPresence presence) {
        assert (!presence.getFriend().isAnonymous());
        this.listLock.writeLock().lock();
        try {
            FriendLibraryImpl friendLibrary = this.getOrCreateFriendLibrary(presence.getFriend());
            boolean bl = friendLibrary.addPresenceLibrary(presence);
            return bl;
        }
        finally {
            this.listLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PresenceLibrary getPresenceLibrary(FriendPresence presence) {
        this.listLock.readLock().lock();
        try {
            FriendLibraryImpl friendLibrary = this.getFriendLibrary(presence.getFriend());
            if (friendLibrary != null) {
                PresenceLibraryImpl presenceLibraryImpl = friendLibrary.getPresenceLibrary(presence);
                return presenceLibraryImpl;
            }
            PresenceLibrary presenceLibrary = null;
            return presenceLibrary;
        }
        finally {
            this.listLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFriendLibrary(FriendLibraryImpl friendLibrary) {
        LOG.debugf("removing friend library for {0}", (Object)friendLibrary.getFriend());
        this.listLock.writeLock().lock();
        try {
            friendLibrary.removeListener(this.propagatingEventListener);
            this.allFriendLibraries.remove(friendLibrary);
        }
        finally {
            this.listLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removePresenceLibrary(FriendPresence presence) {
        this.listLock.writeLock().lock();
        try {
            FriendLibraryImpl friendLibrary = this.getFriendLibrary(presence.getFriend());
            if (friendLibrary != null) {
                friendLibrary.removePresenceLibrary(presence);
                if (friendLibrary.getPresenceLibraryList().isEmpty()) {
                    this.removeFriendLibrary(friendLibrary);
                }
            }
        }
        finally {
            this.listLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FriendLibraryImpl getOrCreateFriendLibrary(Friend friend) {
        this.listLock.writeLock().lock();
        try {
            FriendLibraryImpl friendLibrary = this.getFriendLibrary(friend);
            if (friendLibrary == null) {
                LOG.debugf("adding friend library for {0}", (Object)friend);
                friendLibrary = new FriendLibraryImpl(friend);
                friendLibrary.addListener(this.propagatingEventListener);
                this.allFriendLibraries.add(friendLibrary);
            }
            FriendLibraryImpl friendLibraryImpl = friendLibrary;
            return friendLibraryImpl;
        }
        finally {
            this.listLock.writeLock().unlock();
        }
    }

    @Override
    public boolean hasFriendLibrary(Friend friend) {
        return this.getFriendLibrary(friend) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FriendLibraryImpl getFriendLibrary(Friend friend) {
        this.listLock.readLock().lock();
        try {
            for (FriendLibrary library : this.allFriendLibraries) {
                if (!library.getFriend().getId().equals(friend.getId())) continue;
                FriendLibraryImpl friendLibraryImpl = (FriendLibraryImpl)library;
                return friendLibraryImpl;
            }
            FriendLibraryImpl friendLibraryImpl = null;
            return friendLibraryImpl;
        }
        finally {
            this.listLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static RemoteLibraryState calculateState(EventList<? extends RemoteLibrary> children) {
        children.getReadWriteLock().readLock().lock();
        try {
            RemoteLibraryState remoteLibraryState;
            boolean oneCompleted = false;
            for (RemoteLibrary remoteLibrary : children) {
                switch (remoteLibrary.getState()) {
                    case LOADING: {
                        RemoteLibraryState remoteLibraryState2 = RemoteLibraryState.LOADING;
                        return remoteLibraryState2;
                    }
                    case LOADED: {
                        oneCompleted = true;
                    }
                }
            }
            if (oneCompleted) {
                remoteLibraryState = RemoteLibraryState.LOADED;
                return remoteLibraryState;
            }
            remoteLibraryState = RemoteLibraryState.FAILED_TO_LOAD;
            return remoteLibraryState;
        }
        finally {
            children.getReadWriteLock().readLock().unlock();
        }
    }

    static class PropagatingEventListener
    implements EventListener<RemoteLibraryEvent> {
        private final ParentRemoteLibrary parent;
        private final EventListenerList<RemoteLibraryEvent> listeners;

        public PropagatingEventListener(ParentRemoteLibrary parent, EventListenerList<RemoteLibraryEvent> listeners) {
            this.parent = parent;
            this.listeners = listeners;
        }

        @Override
        public void handleEvent(RemoteLibraryEvent event) {
            switch ((RemoteLibraryEvent.Type)((Object)event.getType())) {
                case STATE_CHANGED: {
                    this.parent.updateState();
                    break;
                }
                case RESULTS_ADDED: {
                    this.listeners.broadcast(RemoteLibraryEvent.createResultsAddedEvent(this.parent, event.getAddedResults(), -1));
                    break;
                }
                case RESULTS_CLEARED: {
                    if (this.parent.size() == 0) {
                        this.listeners.broadcast(RemoteLibraryEvent.createResultsClearedEvent(this.parent));
                        break;
                    }
                    this.listeners.broadcast(RemoteLibraryEvent.createResultsRemovedEvent(this.parent));
                    break;
                }
                case RESULTS_REMOVED: {
                    this.listeners.broadcast(RemoteLibraryEvent.createResultsRemovedEvent(this.parent));
                }
            }
        }
    }

    static interface ParentRemoteLibrary
    extends RemoteLibrary {
        public void updateState();
    }

    static class PresenceLibraryImpl
    implements PresenceLibrary {
        private final FriendPresence presence;
        private volatile RemoteLibraryState state = RemoteLibraryState.LOADING;
        private final List<SearchResult> results = Collections.synchronizedList(new ArrayList());
        private final EventListenerList<RemoteLibraryEvent> listeners = new EventListenerList();
        private final List<AddOnlyListIterator> iterators = new ArrayList<AddOnlyListIterator>(2);

        PresenceLibraryImpl(FriendPresence presence) {
            this.presence = presence;
        }

        public String toString() {
            return StringUtils.toString(this, this.presence);
        }

        @Override
        public FriendPresence getPresence() {
            return this.presence;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void addNewResult(SearchResult file) {
            int startIndex;
            List<SearchResult> list = this.results;
            synchronized (list) {
                startIndex = this.results.size();
                this.results.add(file);
            }
            this.listeners.broadcast(RemoteLibraryEvent.createResultsAddedEvent(this, Collections.singleton(file), startIndex));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void setNewResults(Collection<SearchResult> files) {
            int startIndex;
            this.clear();
            List<SearchResult> list = this.results;
            synchronized (list) {
                startIndex = this.results.size();
                this.results.addAll(files);
            }
            this.listeners.broadcast(RemoteLibraryEvent.createResultsAddedEvent(this, files, startIndex));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void clear() {
            List<SearchResult> list = this.results;
            synchronized (list) {
                this.results.clear();
                for (AddOnlyListIterator iterator : this.iterators) {
                    iterator.cleared = true;
                }
                this.iterators.clear();
            }
            this.listeners.broadcast(RemoteLibraryEvent.createResultsClearedEvent(this));
        }

        @Override
        public int size() {
            return this.results.size();
        }

        @Override
        public RemoteLibraryState getState() {
            return this.state;
        }

        @Override
        public void setState(RemoteLibraryState newState) {
            this.state = newState;
            this.listeners.broadcast(RemoteLibraryEvent.createStateChangedEvent(this));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Iterator<SearchResult> iterator() {
            List<SearchResult> list = this.results;
            synchronized (list) {
                AddOnlyListIterator iterator = new AddOnlyListIterator();
                this.iterators.add(iterator);
                return iterator;
            }
        }

        @Override
        public void addListener(EventListener<RemoteLibraryEvent> listener) {
            this.listeners.addListener(listener);
        }

        @Override
        public boolean removeListener(EventListener<RemoteLibraryEvent> listener) {
            return this.listeners.removeListener(listener);
        }

        @Override
        public SearchResult get(int index) {
            return this.results.get(index);
        }

        private class AddOnlyListIterator
        implements Iterator<SearchResult> {
            private int currentIndex = 0;
            private boolean cleared = false;
            private SearchResult next = null;

            public AddOnlyListIterator() {
                this.setNext();
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void setNext() {
                List list = PresenceLibraryImpl.this.results;
                synchronized (list) {
                    this.next = this.currentIndex < PresenceLibraryImpl.this.results.size() ? (SearchResult)PresenceLibraryImpl.this.results.get(this.currentIndex) : null;
                    ++this.currentIndex;
                }
            }

            @Override
            public boolean hasNext() {
                if (this.cleared) {
                    return false;
                }
                return this.next != null;
            }

            @Override
            public SearchResult next() {
                SearchResult result = this.next;
                this.setNext();
                return result;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        }
    }

    private class FriendLibraryImpl
    implements FriendLibrary,
    ParentRemoteLibrary {
        private final Friend friend;
        private final EventList<PresenceLibrary> allPresenceLibraries;
        private final ReadOnlyList<PresenceLibrary> readOnlyPresenceLibraries;
        private volatile RemoteLibraryState state = RemoteLibraryState.LOADING;
        private final EventListenerList<RemoteLibraryEvent> listeners = new EventListenerList();
        private final PropagatingEventListener propagatingEventListener = new PropagatingEventListener(this, this.listeners);

        public FriendLibraryImpl(Friend friend) {
            this.friend = friend;
            this.allPresenceLibraries = GlazedListsFactory.threadSafeList(new BasicEventList(RemoteLibraryManagerImpl.this.listLock));
            this.readOnlyPresenceLibraries = GlazedListsFactory.readOnlyList(this.allPresenceLibraries);
        }

        @Override
        public EventList<PresenceLibrary> getPresenceLibraryList() {
            return this.readOnlyPresenceLibraries;
        }

        @Override
        public RemoteLibraryState getState() {
            return this.state;
        }

        private void setState(RemoteLibraryState state) {
            this.state = state;
            this.listeners.broadcast(RemoteLibraryEvent.createStateChangedEvent(this));
        }

        @Override
        public void updateState() {
            this.setState(RemoteLibraryManagerImpl.calculateState(this.allPresenceLibraries));
        }

        @Override
        public Friend getFriend() {
            return this.friend;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private PresenceLibraryImpl getPresenceLibrary(FriendPresence presence) {
            RemoteLibraryManagerImpl.this.listLock.readLock().lock();
            try {
                for (PresenceLibrary library : this.allPresenceLibraries) {
                    if (!library.getPresence().getPresenceId().equals(presence.getPresenceId())) continue;
                    PresenceLibraryImpl presenceLibraryImpl = (PresenceLibraryImpl)library;
                    return presenceLibraryImpl;
                }
                PresenceLibraryImpl presenceLibraryImpl = null;
                return presenceLibraryImpl;
            }
            finally {
                RemoteLibraryManagerImpl.this.listLock.readLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean addPresenceLibrary(FriendPresence presence) {
            RemoteLibraryManagerImpl.this.listLock.writeLock().lock();
            try {
                PresenceLibraryImpl library = this.getPresenceLibrary(presence);
                if (library == null) {
                    LOG.debugf("adding presence library for {0}", (Object)presence);
                    library = new PresenceLibraryImpl(presence);
                    this.allPresenceLibraries.add(library);
                    library.addListener(this.propagatingEventListener);
                    boolean bl = true;
                    return bl;
                }
                boolean bl = false;
                return bl;
            }
            finally {
                RemoteLibraryManagerImpl.this.listLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void removePresenceLibrary(FriendPresence presence) {
            RemoteLibraryManagerImpl.this.listLock.writeLock().lock();
            try {
                PresenceLibraryImpl presenceLibrary = this.getPresenceLibrary(presence);
                if (presenceLibrary != null) {
                    LOG.debugf("removing presence library for {0}", (Object)presence);
                    presenceLibrary.removeListener(this.propagatingEventListener);
                    this.allPresenceLibraries.remove(presenceLibrary);
                }
            }
            finally {
                RemoteLibraryManagerImpl.this.listLock.writeLock().unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            RemoteLibraryManagerImpl.this.listLock.readLock().lock();
            try {
                int sum = 0;
                for (PresenceLibrary presenceLibrary : this.readOnlyPresenceLibraries) {
                    sum += presenceLibrary.size();
                }
                int n = sum;
                return n;
            }
            finally {
                RemoteLibraryManagerImpl.this.listLock.readLock().unlock();
            }
        }

        @Override
        public void addNewResult(SearchResult file) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNewResults(Collection<SearchResult> file) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return StringUtils.toString(this, new Object[0]);
        }

        @Override
        public Iterator<SearchResult> iterator() {
            return new MultiIterable(this.readOnlyPresenceLibraries.toArray(new RemoteLibrary[0])).iterator();
        }

        @Override
        public void addListener(EventListener<RemoteLibraryEvent> listener) {
            this.listeners.addListener(listener);
        }

        @Override
        public boolean removeListener(EventListener<RemoteLibraryEvent> listener) {
            return this.listeners.removeListener(listener);
        }
    }

    private class AllFriendsLibraryImpl
    implements ParentRemoteLibrary {
        private volatile RemoteLibraryState state = RemoteLibraryState.LOADING;

        private AllFriendsLibraryImpl() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public int size() {
            RemoteLibraryManagerImpl.this.listLock.readLock().lock();
            try {
                int sum = 0;
                for (FriendLibrary remoteLibrary : RemoteLibraryManagerImpl.this.allFriendLibraries) {
                    sum += remoteLibrary.size();
                }
                int n = sum;
                return n;
            }
            finally {
                RemoteLibraryManagerImpl.this.listLock.readLock().unlock();
            }
        }

        @Override
        public void addNewResult(SearchResult file) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setNewResults(Collection<SearchResult> files) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public RemoteLibraryState getState() {
            return this.state;
        }

        public void setState(RemoteLibraryState state) {
            this.state = state;
            RemoteLibraryManagerImpl.this.listeners.broadcast(RemoteLibraryEvent.createStateChangedEvent(this));
        }

        @Override
        public Iterator<SearchResult> iterator() {
            return new MultiIterable(RemoteLibraryManagerImpl.this.allFriendLibraries.toArray(new RemoteLibrary[0])).iterator();
        }

        @Override
        public void addListener(EventListener<RemoteLibraryEvent> listener) {
            RemoteLibraryManagerImpl.this.listeners.addListener(listener);
        }

        @Override
        public boolean removeListener(EventListener<RemoteLibraryEvent> listener) {
            return RemoteLibraryManagerImpl.this.listeners.removeListener(listener);
        }

        @Override
        public void updateState() {
            this.setState(RemoteLibraryManagerImpl.calculateState(RemoteLibraryManagerImpl.this.allFriendLibraries));
        }
    }

    @InspectableContainer
    private class LazyInspectableContainer {
        @InspectionPoint(value="remote libraries", category=DataCategory.USAGE)
        private final Inspectable inspectable = new Inspectable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object inspect() {
                HashMap data = new HashMap();
                RemoteLibraryManagerImpl.this.listLock.readLock().lock();
                try {
                    ArrayList<Integer> sizes = new ArrayList<Integer>(RemoteLibraryManagerImpl.this.readOnlyFriendLibraries.size());
                    for (FriendLibrary friendLibrary : RemoteLibraryManagerImpl.this.readOnlyFriendLibraries) {
                        sizes.add(friendLibrary.size());
                    }
                    data.put("sizes", sizes);
                }
                finally {
                    RemoteLibraryManagerImpl.this.listLock.readLock().unlock();
                }
                return data;
            }
        };

        private LazyInspectableContainer() {
        }
    }
}

