/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl.search.browse;

import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import java.util.ArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.limewire.core.api.library.FriendLibrary;
import org.limewire.core.api.library.RemoteLibraryEvent;
import org.limewire.core.api.library.RemoteLibraryManager;
import org.limewire.core.api.library.RemoteLibraryState;
import org.limewire.core.api.search.SearchListener;
import org.limewire.core.api.search.SearchResult;
import org.limewire.core.api.search.browse.BrowseStatus;
import org.limewire.core.api.search.browse.BrowseStatusListener;
import org.limewire.core.impl.search.browse.AbstractBrowseSearch;
import org.limewire.friend.api.Friend;
import org.limewire.listener.EventListener;

class FriendSingleBrowseSearch
extends AbstractBrowseSearch {
    private final Friend friend;
    private final RemoteLibraryManager remoteLibraryManager;
    private final ExecutorService executorService;
    private final ListEventListener<FriendLibrary> friendLibraryListEventListener = new FriendLibraryListEventListener();
    private final EventListener<RemoteLibraryEvent> eventAdapter = new RemoteLibraryToBrowseEventAdapter();
    private final AtomicReference<FriendLibrary> currentLibrary = new AtomicReference();
    private boolean hasRegisteredListener = false;
    private final AtomicBoolean hasStopped = new AtomicBoolean(false);
    private Future startFuture = null;

    public FriendSingleBrowseSearch(RemoteLibraryManager remoteLibraryManager, Friend friend, ExecutorService executorService) {
        assert (friend != null && !friend.isAnonymous());
        this.friend = friend;
        this.remoteLibraryManager = remoteLibraryManager;
        this.executorService = executorService;
    }

    @Override
    public void start() {
        this.startFuture = this.executorService.submit(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                for (SearchListener listener : FriendSingleBrowseSearch.this.searchListeners) {
                    if (FriendSingleBrowseSearch.this.hasStopped.get()) {
                        return;
                    }
                    listener.searchStarted(FriendSingleBrowseSearch.this);
                }
                if (!FriendSingleBrowseSearch.this.hasStopped.get()) {
                    FriendSingleBrowseSearch friendSingleBrowseSearch = FriendSingleBrowseSearch.this;
                    synchronized (friendSingleBrowseSearch) {
                        FriendSingleBrowseSearch.this.installListener();
                    }
                }
                if (!FriendSingleBrowseSearch.this.hasStopped.get()) {
                    FriendSingleBrowseSearch.this.startFriendBrowse();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (this.startFuture != null && !this.startFuture.isDone()) {
            this.startFuture.cancel(true);
        }
        this.hasStopped.set(true);
        for (SearchListener listener : this.searchListeners) {
            listener.searchStopped(this);
        }
        FriendSingleBrowseSearch friendSingleBrowseSearch = this;
        synchronized (friendSingleBrowseSearch) {
            this.removeListener();
        }
    }

    private void startFriendBrowse() {
        FriendLibrary library = this.remoteLibraryManager.getFriendLibrary(this.friend);
        if (library == null) {
            this.fireBrowseStatusChanged(BrowseStatus.BrowseState.OFFLINE, this.friend);
            for (SearchListener listener : this.searchListeners) {
                listener.searchStopped(this);
            }
        } else {
            this.setLibrary(library);
            if (library.getState() == RemoteLibraryState.LOADING) {
                library.addListener(this.eventAdapter);
            } else {
                this.loadLibrary();
            }
        }
    }

    private void loadLibrary() {
        FriendLibrary friendLibrary = this.remoteLibraryManager.getFriendLibrary(this.friend);
        ArrayList<SearchResult> searchResults = new ArrayList<SearchResult>(friendLibrary.size());
        for (SearchResult result : friendLibrary) {
            searchResults.add(result);
        }
        for (SearchListener listener : this.searchListeners) {
            listener.handleSearchResults(this, searchResults);
        }
        this.fireBrowseStatusChanged(BrowseStatus.BrowseState.LOADED, new Friend[0]);
        for (SearchListener listener : this.searchListeners) {
            listener.searchStopped(this);
        }
    }

    private void installListener() {
        this.remoteLibraryManager.getFriendLibraryList().addListEventListener(this.friendLibraryListEventListener);
        this.hasRegisteredListener = true;
    }

    private void removeListener() {
        if (this.hasRegisteredListener) {
            this.remoteLibraryManager.getFriendLibraryList().removeListEventListener(this.friendLibraryListEventListener);
        }
        this.hasRegisteredListener = false;
        this.setLibrary(null);
    }

    private void setLibrary(FriendLibrary newLibrary) {
        FriendLibrary oldLibrary = this.currentLibrary.getAndSet(newLibrary);
        if (newLibrary == oldLibrary) {
            return;
        }
        if (oldLibrary != null) {
            oldLibrary.removeListener(this.eventAdapter);
        }
        if (newLibrary == null) {
            return;
        }
        newLibrary.addListener(this.eventAdapter);
        if (newLibrary.getState() == RemoteLibraryState.LOADED) {
            this.fireBrowseStatusChanged(BrowseStatus.BrowseState.UPDATED, new Friend[0]);
        }
    }

    private void fireBrowseStatusChanged(BrowseStatus.BrowseState state, Friend ... friends) {
        BrowseStatus status = new BrowseStatus(this, state, friends);
        for (BrowseStatusListener listener : this.browseStatusListeners) {
            listener.statusChanged(status);
        }
    }

    @Override
    public void repeat() {
        this.stop();
        this.hasStopped.set(false);
        this.start();
    }

    private class RemoteLibraryToBrowseEventAdapter
    implements EventListener<RemoteLibraryEvent> {
        private RemoteLibraryToBrowseEventAdapter() {
        }

        @Override
        public void handleEvent(RemoteLibraryEvent event) {
            switch ((RemoteLibraryEvent.Type)((Object)event.getType())) {
                case STATE_CHANGED: {
                    RemoteLibraryState state = event.getState();
                    if (state == RemoteLibraryState.LOADING) break;
                    if (state == RemoteLibraryState.LOADED) {
                        FriendSingleBrowseSearch.this.fireBrowseStatusChanged(BrowseStatus.BrowseState.UPDATED, new Friend[0]);
                        break;
                    }
                    FriendSingleBrowseSearch.this.fireBrowseStatusChanged(BrowseStatus.BrowseState.FAILED, new Friend[]{FriendSingleBrowseSearch.this.friend});
                    break;
                }
                case RESULTS_ADDED: 
                case RESULTS_CLEARED: 
                case RESULTS_REMOVED: {
                    FriendSingleBrowseSearch.this.fireBrowseStatusChanged(BrowseStatus.BrowseState.UPDATED, new Friend[0]);
                }
            }
        }
    }

    private class FriendLibraryListEventListener
    implements ListEventListener<FriendLibrary> {
        private FriendLibraryListEventListener() {
        }

        @Override
        public void listChanged(ListEvent listChanges) {
            while (listChanges.next()) {
                if (listChanges.getType() == 2) {
                    FriendLibrary newLibrary = (FriendLibrary)listChanges.getSourceList().get(listChanges.getIndex());
                    if (!newLibrary.getFriend().getId().equals(FriendSingleBrowseSearch.this.friend.getId())) continue;
                    FriendSingleBrowseSearch.this.setLibrary(FriendSingleBrowseSearch.this.remoteLibraryManager.getFriendLibrary(FriendSingleBrowseSearch.this.friend));
                    continue;
                }
                if (listChanges.getType() != 0 || FriendSingleBrowseSearch.this.remoteLibraryManager.getFriendLibrary(FriendSingleBrowseSearch.this.friend) != null) continue;
                FriendSingleBrowseSearch.this.setLibrary(null);
                FriendSingleBrowseSearch.this.fireBrowseStatusChanged(BrowseStatus.BrowseState.OFFLINE, new Friend[]{FriendSingleBrowseSearch.this.friend});
            }
        }
    }
}

