/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl.search.browse;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.limewire.core.api.search.Search;
import org.limewire.core.api.search.SearchListener;
import org.limewire.core.api.search.SearchResult;
import org.limewire.core.api.search.browse.BrowseSearch;
import org.limewire.core.api.search.browse.BrowseSearchFactory;
import org.limewire.core.api.search.browse.BrowseStatus;
import org.limewire.core.api.search.browse.BrowseStatusListener;
import org.limewire.core.api.search.sponsored.SponsoredResult;
import org.limewire.core.impl.search.browse.AbstractBrowseSearch;
import org.limewire.friend.api.Friend;
import org.limewire.friend.api.FriendPresence;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;

class MultipleBrowseSearch
extends AbstractBrowseSearch {
    private static final Log LOG = LogFactory.getLog(MultipleBrowseSearch.class);
    private static final int PARALLEL_BROWSES = 2;
    private final CombinedSearchListener combinedSearchListener = new CombinedSearchListener();
    private final CombinedBrowseStatusListener combinedBrowseStatusListener = new CombinedBrowseStatusListener();
    private final List<BrowseSearch> activeBrowses = new CopyOnWriteArrayList<BrowseSearch>();
    private final List<FriendPresence> presences;
    private final Queue<FriendPresence> pendingPresences;
    private final BrowseSearchFactory browseSearchFactory;

    public MultipleBrowseSearch(BrowseSearchFactory browseSearchFactory, Collection<FriendPresence> presences) {
        this.browseSearchFactory = browseSearchFactory;
        this.presences = new ArrayList<FriendPresence>(presences);
        this.pendingPresences = new ConcurrentLinkedQueue<FriendPresence>();
    }

    @Override
    public void start() {
        this.pendingPresences.addAll(this.presences);
        for (int i = 0; i < 2 && !this.pendingPresences.isEmpty() && this.startPendingBrowse(); ++i) {
        }
    }

    private boolean startPendingBrowse() {
        FriendPresence host = this.pendingPresences.poll();
        if (host != null) {
            LOG.debugf("Starting browse for host {0}", (Object)host);
            BrowseSearch browse = this.browseSearchFactory.createBrowseSearch(host);
            browse.addSearchListener(this.combinedSearchListener);
            browse.addBrowseStatusListener(this.combinedBrowseStatusListener);
            this.activeBrowses.add(browse);
            browse.start();
            return true;
        }
        LOG.debugf("Attempted to start pending browse, but no hosts left.", new Object[0]);
        return false;
    }

    @Override
    public void stop() {
        this.pendingPresences.clear();
        for (BrowseSearch browse : this.activeBrowses) {
            browse.stop();
        }
    }

    @Override
    public void repeat() {
        this.stop();
        this.combinedBrowseStatusListener.clear();
        this.combinedSearchListener.clear();
        this.start();
    }

    private class CombinedBrowseStatusListener
    implements BrowseStatusListener {
        private List<Friend> failedList = new CopyOnWriteArrayList<Friend>();
        private AtomicInteger loaded = new AtomicInteger(0);
        private AtomicBoolean hasUpdated = new AtomicBoolean(false);

        private CombinedBrowseStatusListener() {
        }

        @Override
        public void statusChanged(BrowseStatus status) {
            LOG.debugf("Received status change event {0}", (Object)status);
            switch (status.getState()) {
                case FAILED: 
                case OFFLINE: {
                    this.failedList.addAll(status.getFailedFriends());
                    break;
                }
                case UPDATED: {
                    this.hasUpdated.set(true);
                    break;
                }
                case LOADED: {
                    this.loaded.incrementAndGet();
                }
            }
            BrowseStatus.BrowseState state = this.getReleventMultipleBrowseState(status);
            if (state != null) {
                BrowseStatus browseStatus = new BrowseStatus(MultipleBrowseSearch.this, state, this.failedList.toArray(new Friend[this.failedList.size()]));
                for (BrowseStatusListener listener : MultipleBrowseSearch.this.browseStatusListeners) {
                    listener.statusChanged(browseStatus);
                }
            }
            MultipleBrowseSearch.this.activeBrowses.remove(status.getBrowseSearch());
            MultipleBrowseSearch.this.startPendingBrowse();
        }

        public void clear() {
            this.hasUpdated.set(false);
            this.loaded.set(0);
            this.failedList.clear();
        }

        private BrowseStatus.BrowseState getReleventMultipleBrowseState(BrowseStatus status) {
            if (this.loaded.get() == MultipleBrowseSearch.this.presences.size()) {
                return BrowseStatus.BrowseState.LOADED;
            }
            if (this.failedList.size() == MultipleBrowseSearch.this.presences.size()) {
                return BrowseStatus.BrowseState.FAILED;
            }
            if (this.failedList.size() > 0) {
                if (this.loaded.get() > 0) {
                    if (this.hasUpdated.get()) {
                        return BrowseStatus.BrowseState.UPDATED_PARTIAL_FAIL;
                    }
                    return BrowseStatus.BrowseState.PARTIAL_FAIL;
                }
            } else if (this.hasUpdated.get()) {
                return BrowseStatus.BrowseState.UPDATED;
            }
            return BrowseStatus.BrowseState.LOADING;
        }
    }

    private class CombinedSearchListener
    implements SearchListener {
        private AtomicInteger stoppedBrowses = new AtomicInteger(0);

        private CombinedSearchListener() {
        }

        @Override
        public void handleSearchResult(Search search, SearchResult searchResult) {
            for (SearchListener listener : MultipleBrowseSearch.this.searchListeners) {
                listener.handleSearchResult(MultipleBrowseSearch.this, searchResult);
            }
        }

        @Override
        public void handleSearchResults(Search search, Collection<? extends SearchResult> searchResults) {
            for (SearchListener listener : MultipleBrowseSearch.this.searchListeners) {
                listener.handleSearchResults(MultipleBrowseSearch.this, searchResults);
            }
        }

        public void clear() {
            this.stoppedBrowses.set(0);
        }

        @Override
        public void handleSponsoredResults(Search search, List<SponsoredResult> sponsoredResults) {
            for (SearchListener listener : MultipleBrowseSearch.this.searchListeners) {
                listener.handleSponsoredResults(MultipleBrowseSearch.this, sponsoredResults);
            }
        }

        @Override
        public void searchStarted(Search search) {
            for (SearchListener listener : MultipleBrowseSearch.this.searchListeners) {
                listener.searchStarted(MultipleBrowseSearch.this);
            }
        }

        @Override
        public void searchStopped(Search search) {
            LOG.debugf("Received search stopped event {0}", (Object)search);
            if (this.stoppedBrowses.incrementAndGet() == MultipleBrowseSearch.this.presences.size()) {
                for (SearchListener listener : MultipleBrowseSearch.this.searchListeners) {
                    listener.searchStopped(MultipleBrowseSearch.this);
                }
            }
        }
    }
}

