/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.impl.upload;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.ObservableElementList;
import ca.odell.glazedlists.impl.ThreadSafeList;
import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.limegroup.bittorrent.BTUploader;
import com.limegroup.gnutella.UploadServices;
import com.limegroup.gnutella.Uploader;
import java.awt.EventQueue;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.limewire.collection.glazedlists.GlazedListsFactory;
import org.limewire.core.api.upload.UploadItem;
import org.limewire.core.api.upload.UploadListManager;
import org.limewire.core.api.upload.UploadState;
import org.limewire.core.impl.friend.BittorrentPresence;
import org.limewire.core.impl.friend.GnutellaPresence;
import org.limewire.core.impl.upload.CoreUploadItem;
import org.limewire.core.impl.upload.UploadListener;
import org.limewire.core.impl.upload.UploadListenerList;
import org.limewire.core.settings.SharingSettings;
import org.limewire.friend.api.FriendManager;
import org.limewire.friend.api.FriendPresence;
import org.limewire.inject.EagerSingleton;
import org.limewire.io.ConnectableImpl;
import org.limewire.lifecycle.ServiceScheduler;
import org.limewire.listener.SwingSafePropertyChangeSupport;

@EagerSingleton
public class CoreUploadListManager
implements UploadListener,
UploadListManager {
    private final CoreUploadItem.Factory cuiFactory;
    private final UploadServices uploadServices;
    private final FriendManager friendManager;
    private final PropertyChangeSupport changeSupport = new SwingSafePropertyChangeSupport(this);
    private final EventList<UploadItem> uploadItems;
    private EventList<UploadItem> swingThreadUploadItems;
    private ThreadSafeList<UploadItem> threadSafeUploadItems;
    private static final int PERIOD = 1000;

    @Inject
    public CoreUploadListManager(UploadServices uploadServices, FriendManager friendManager, CoreUploadItem.Factory cuiFactory) {
        this.cuiFactory = cuiFactory;
        this.uploadServices = uploadServices;
        this.friendManager = friendManager;
        this.threadSafeUploadItems = GlazedListsFactory.threadSafeList(new BasicEventList());
        ObservableElementList.Connector<UploadItem> uploadConnector = GlazedLists.beanConnector(UploadItem.class);
        this.uploadItems = GlazedListsFactory.observableElementList(this.threadSafeUploadItems, uploadConnector);
    }

    @Inject
    public void register(UploadListenerList uploadListenerList) {
        uploadListenerList.addUploadListener(this);
    }

    @Inject
    public void register(ServiceScheduler scheduler, @Named(value="backgroundExecutor") ScheduledExecutorService executor) {
        Runnable command = new Runnable(){

            @Override
            public void run() {
                CoreUploadListManager.this.update();
            }
        };
        scheduler.scheduleWithFixedDelay("UI Upload Status Monitor", command, 0L, 1000L, TimeUnit.MILLISECONDS, executor).in(this);
    }

    @Override
    public List<UploadItem> getUploadItems() {
        return this.uploadItems;
    }

    @Override
    public EventList<UploadItem> getSwingThreadSafeUploads() {
        assert (EventQueue.isDispatchThread());
        if (this.swingThreadUploadItems == null) {
            this.swingThreadUploadItems = GlazedListsFactory.swingThreadProxyEventList(this.uploadItems);
        }
        return this.swingThreadUploadItems;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.addPropertyChangeListener(listener);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.changeSupport.removePropertyChangeListener(listener);
    }

    @Override
    public void updateUploadsCompleted() {
        if (this.uploadServices.getNumUploads() == 0) {
            this.uploadsCompleted();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void uploadAdded(Uploader uploader) {
        if (!uploader.getUploadType().isInternal()) {
            CoreUploadItem currentItem = this.findMatchingUploader(uploader);
            CoreUploadItem newItem = this.cuiFactory.create(uploader, this.getFriendPresence(uploader));
            if (currentItem == null) {
                this.threadSafeUploadItems.add(newItem);
            } else {
                this.threadSafeUploadItems.getReadWriteLock().writeLock().lock();
                try {
                    this.threadSafeUploadItems.set(this.threadSafeUploadItems.indexOf(currentItem), newItem);
                }
                finally {
                    this.threadSafeUploadItems.getReadWriteLock().writeLock().unlock();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CoreUploadItem findMatchingUploader(Uploader uploader) {
        CoreUploadItem matchingItem = null;
        this.threadSafeUploadItems.getReadWriteLock().readLock().lock();
        try {
            for (UploadItem item : this.threadSafeUploadItems) {
                CoreUploadItem coreUploadItem = (CoreUploadItem)item;
                if (!coreUploadItem.getUploader().getHost().equals(uploader.getHost())) continue;
                if (uploader.getState() == Uploader.UploadStatus.BROWSE_HOST && uploader.getUploadType() == coreUploadItem.getUploader().getUploadType()) {
                    matchingItem = coreUploadItem;
                } else {
                    if (uploader.getFile() == null || !uploader.getFile().equals(coreUploadItem.getFile())) continue;
                    matchingItem = coreUploadItem;
                }
                break;
            }
        }
        finally {
            this.threadSafeUploadItems.getReadWriteLock().readLock().unlock();
        }
        return matchingItem;
    }

    @Override
    public void uploadComplete(Uploader uploader) {
        CoreUploadItem item = this.cuiFactory.create(uploader, this.getFriendPresence(uploader));
        item.finish();
        UploadState state = item.getState();
        if (state == UploadState.CANCELED) {
            this.remove(item);
        } else if (state == UploadState.DONE || state == UploadState.BROWSE_HOST_DONE || state.isError()) {
            if (SharingSettings.CLEAR_UPLOAD.getValue()) {
                this.remove(item);
            } else {
                int i = this.threadSafeUploadItems.indexOf(item);
                if (i > -1) {
                    ((CoreUploadItem)this.threadSafeUploadItems.get(i)).finish();
                }
            }
        }
    }

    @Override
    public void uploadsCompleted() {
        this.changeSupport.firePropertyChange("uploadsCompleted", false, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void update() {
        this.uploadItems.getReadWriteLock().writeLock().lock();
        try {
            for (UploadItem item : this.uploadItems) {
                if (item.getState() == UploadState.DONE || item.getState() == UploadState.BROWSE_HOST_DONE || !(item instanceof CoreUploadItem)) continue;
                ((CoreUploadItem)item).refresh();
            }
        }
        finally {
            this.uploadItems.getReadWriteLock().writeLock().unlock();
        }
    }

    private FriendPresence getFriendPresence(Uploader uploader) {
        if (uploader instanceof BTUploader) {
            return new BittorrentPresence(uploader);
        }
        String id = uploader.getPresenceId();
        FriendPresence currentPresence = null;
        if (id != null) {
            currentPresence = this.friendManager.getMostRelevantFriendPresence(id);
        }
        if (currentPresence == null) {
            currentPresence = new GnutellaPresence.GnutellaPresenceWithString(new ConnectableImpl(uploader), uploader.getHost());
        }
        return currentPresence;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clearFinished() {
        ArrayList<UploadItem> finishedItems = new ArrayList<UploadItem>();
        this.threadSafeUploadItems.getReadWriteLock().writeLock().lock();
        try {
            for (UploadItem item : this.threadSafeUploadItems) {
                UploadState state = item.getState();
                if (!state.isFinished() && !state.isError()) continue;
                finishedItems.add(item);
            }
            this.threadSafeUploadItems.removeAll(finishedItems);
        }
        finally {
            this.threadSafeUploadItems.getReadWriteLock().writeLock().unlock();
        }
    }

    @Override
    public void remove(UploadItem item) {
        this.threadSafeUploadItems.remove(item);
    }
}

