/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.settings;

import org.limewire.core.settings.LimeProps;
import org.limewire.inspection.InspectionPoint;
import org.limewire.setting.BooleanSetting;
import org.limewire.setting.IntSetting;
import org.limewire.setting.PasswordSetting;
import org.limewire.setting.StringArraySetting;
import org.limewire.setting.StringSetting;
import org.limewire.util.OSUtils;

public class DaapSettings
extends LimeProps {
    @InspectionPoint(value="share with itunes")
    public static BooleanSetting DAAP_ENABLED = FACTORY.createBooleanSetting("DAAP_ENABLED", true);
    public static StringArraySetting DAAP_SUPPORTED_AUDIO_FILE_TYPES = FACTORY.createStringArraySetting("DAAP_SUPPORTED_AUDIO_FILE_TYPES", new String[]{".mp3", ".m4a", ".wav", ".aif", ".aiff", ".m1a"});
    public static StringArraySetting DAAP_SUPPORTED_VIDEO_FILE_TYPES = FACTORY.createStringArraySetting("DAAP_SUPPORTED_VIDEO_FILE_TYPES", new String[]{".mov", ".mp4", ".mpg", ".mpeg"});
    public static StringSetting DAAP_LIBRARY_NAME = (StringSetting)FACTORY.createStringSetting("DAAP_LIBRARY_NAME", DaapSettings.getPossessiveUserName() + " LimeWire Files").setPrivate(true);
    public static IntSetting DAAP_MAX_CONNECTIONS = FACTORY.createIntSetting("DAAP_MAX_CONNECTIONS", 5);
    public static IntSetting DAAP_PORT = FACTORY.createIntSetting("DAAP_PORT", 5214);
    public static StringSetting DAAP_TYPE_NAME = FACTORY.createStringSetting("DAAP_TYPE_NAME", "_daap._tcp.local.");
    public static StringSetting DAAP_SERVICE_NAME = (StringSetting)FACTORY.createStringSetting("DAAP_SERVICE_NAME", DaapSettings.getPossessiveUserName() + " LimeWire Files").setPrivate(true);
    public static IntSetting DAAP_WEIGHT = FACTORY.createIntSetting("DAAP_WEIGHT", 0);
    public static IntSetting DAAP_PRIORITY = FACTORY.createIntSetting("DAAP_PRIORITY", 0);
    public static BooleanSetting DAAP_REQUIRES_USERNAME = FACTORY.createBooleanSetting("DAAP_REQUIRES_USERNAME", false);
    public static BooleanSetting DAAP_REQUIRES_PASSWORD = FACTORY.createBooleanSetting("DAAP_REQUIRES_PASSWORD", false);
    public static StringSetting DAAP_USERNAME = FACTORY.createStringSetting("DAAP_USERNAME", "");
    public static PasswordSetting DAAP_PASSWORD = FACTORY.createPasswordSettingMD5("DAAP_PASSWORD", "");
    public static IntSetting DAAP_MAX_LIBRARY_SIZE = FACTORY.createIntSetting("DAAP_MAX_LIBRARY_SIZE", 10000);
    public static IntSetting DAAP_BUFFER_SIZE = FACTORY.createIntSetting("DAAP_BUFFER_SIZE_2", 2048);

    private DaapSettings() {
    }

    private static String getPossessiveUserName() {
        String name = null;
        if (OSUtils.isMacOSX()) {
            name = System.getProperty("user.fullname", null);
        }
        if (name == null) {
            name = System.getProperty("user.name", "Unknown");
        }
        name = !name.endsWith("s") ? name + "'s" : name + "'";
        return name;
    }
}

