/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.core.settings;

import java.io.File;
import java.io.IOException;
import java.util.Hashtable;
import org.limewire.core.api.Category;
import org.limewire.core.settings.LimeProps;
import org.limewire.inspection.DataCategory;
import org.limewire.inspection.InspectableContainer;
import org.limewire.inspection.InspectablePrimitive;
import org.limewire.inspection.InspectionPoint;
import org.limewire.setting.BooleanSetting;
import org.limewire.setting.FileSetting;
import org.limewire.setting.IntSetting;
import org.limewire.setting.StringSetting;
import org.limewire.util.CommonUtils;
import org.limewire.util.FileUtils;
import org.limewire.util.OSUtils;
import org.limewire.util.SystemUtils;

public class SharingSettings
extends LimeProps {
    private static final Hashtable<String, FileSetting> downloadDirsByDescription = new Hashtable();
    public static final File DEFAULT_SAVE_DIR = new File(SharingSettings.getLimeWireRootFolder(), "Saved");
    public static final File DEFAULT_SHARE_DIR = new File(SharingSettings.getLimeWireRootFolder(), "Shared");
    public static final File DEFAULT_SAVE_LWS_DIR = new File(SharingSettings.getLimeWireRootFolder(), "Store Purchased");
    public static final String DEFAULT_LWS_FILENAME_TEMPLATE = "<artist> - <album> - <track> - <title>";
    public static final String DEFAULT_LWS_FOLDER_TEMPLATE = "<artist>" + File.separatorChar + "<album>";
    public static final BooleanSetting ADD_ALTERNATE_FOR_SELF = FACTORY.createBooleanSetting("ADD_ALTERNATE_FOR_SELF", true);
    public static final FileSetting DIRECTORY_FOR_SAVING_FILES = FACTORY.createFileSetting("DIRECTORY_FOR_SAVING_FILES", DEFAULT_SAVE_DIR).setAlwaysSave(true);
    public static final StringSetting TEMPLATE_SUBDIRECTORY_LWS_FILES = FACTORY.createStringSetting("TEMPLATE_FOR_SAVING_LWS_FILES", DEFAULT_LWS_FOLDER_TEMPLATE);
    public static final StringSetting TEMPLATE_FOR_NAMING_LWS_FILES = FACTORY.createStringSetting("TEMPLATE_FOR_NAMING_LWS_FILES", "<artist> - <album> - <track> - <title>");
    public static final FileSetting INCOMPLETE_DIRECTORY = FACTORY.createFileSetting("INCOMPLETE_DIRECTORY", new File(DIRECTORY_FOR_SAVING_FILES.get().getParent(), "Incomplete"));
    public static final FileSetting OLD_DOWNLOAD_SNAPSHOT_FILE = FACTORY.createFileSetting("DOWNLOAD_SNAPSHOT_FILE", new File(INCOMPLETE_DIRECTORY.get(), "downloads.dat"));
    public static final FileSetting OLD_DOWNLOAD_SNAPSHOT_BACKUP_FILE = FACTORY.createFileSetting("DOWNLOAD_SNAPSHOT_BACKUP_FILE", new File(INCOMPLETE_DIRECTORY.get(), "downloads.bak"));
    public static final IntSetting INCOMPLETE_PURGE_TIME = FACTORY.createIntSetting("INCOMPLETE_PURGE_TIME", 7);
    public static final IntSetting TORRENT_METADATA_PURGE_TIME = FACTORY.createIntSetting("TORRENT_METADATA_PURGE_TIME", 7);
    @InspectionPoint(value="clear finished downloads", category=DataCategory.USAGE)
    public static final BooleanSetting CLEAR_DOWNLOAD = FACTORY.createBooleanSetting("CLEAR_DOWNLOAD", false);
    public static final BooleanSetting WARN_SHARING_FOLDER = FACTORY.createBooleanSetting("WARN_SHARING_FOLDER", true);
    public static final BooleanSetting WARN_SHARING_DOCUMENTS_WITH_WORLD = FACTORY.createBooleanSetting("WARN_SHARING_DOCUMENTS_WITH_WORLD", true);
    @InspectionPoint(value="auto-sharing enabled", category=DataCategory.USAGE)
    public static final BooleanSetting SHARE_DOWNLOADED_FILES_IN_NON_SHARED_DIRECTORIES = FACTORY.createBooleanSetting("SHARE_DOWNLOADED_FILES_IN_NON_SHARED_DIRECTORIES", true);
    public static final IntSetting FREELOADER_ALLOWED = FACTORY.createIntSetting("FREELOADER_ALLOWED_2", 100);
    public static final IntSetting FREELOADER_FILES = FACTORY.createIntSetting("FREELOADER_FILES_2", 1);
    public static final IntSetting PERSISTENT_HTTP_CONNECTION_TIMEOUT = FACTORY.createIntSetting("PERSISTENT_HTTP_CONNECTION_TIMEOUT", 15000);
    public static final BooleanSetting CLEAR_UPLOAD = FACTORY.createBooleanSetting("CLEAR_UPLOAD", true);
    public static final BooleanSetting ALLOW_BROWSER = FACTORY.createBooleanSetting("ALLOW_BROWSER", false);
    public static final BooleanSetting FRIENDLY_HASHING = FACTORY.createBooleanSetting("FRIENDLY_HASHING", true);
    public static final IntSetting MIN_IDLE_TIME_FOR_FULL_HASHING = FACTORY.createIntSetting("MIN_IDLE_TIME_FOR_FULL_HASHING", 300000);
    public static final IntSetting FILES_FOR_WARNING = FACTORY.createIntSetting("FILES_FOR_WARNING", 1000);
    public static final IntSetting DEPTH_FOR_WARNING = FACTORY.createIntSetting("DEPTH_FOR_WARNING", 4);
    public static final StringSetting CREATIVE_COMMONS_INTRO_URL = FACTORY.createRemoteStringSetting("CREATIVE_COMMONS_URL", "http://creativecommons.org/about/licenses/how1", "creativeCommonsURL");
    public static final StringSetting CREATIVE_COMMONS_VERIFICATION_URL = FACTORY.createRemoteStringSetting("CREATIVE_COMMONS_VERIFICATION_URL", "http://creativecommons.org/technology/embedding#2", "creativeCommonsVerificationURL");
    public static final BooleanSetting ALLOW_PARTIAL_SHARING = FACTORY.createBooleanSetting("ALLOW_PARTIAL_SHARING", true);
    public static final BooleanSetting ALLOW_PARTIAL_RESPONSES = FACTORY.createRemoteBooleanSetting("ALLOW_PARTIAL_RESPONSES", true, "SharingSettings.allowPartialResponses");
    public static final IntSetting MAX_PARTIAL_ENCODING_SIZE = FACTORY.createRemoteIntSetting("MAX_PARTIAL_ENCODING_SIZE", 20, "SharingSettings.maxPartialEncodingSize", 10, 40);
    public static final BooleanSetting PUBLISH_PARTIAL_QRP = FACTORY.createRemoteBooleanSetting("PUBLISH_PARTIAL_QRP", true, "SharingSettings.publishPartialQRP");
    public static final BooleanSetting LOAD_PARTIAL_KEYWORDS = FACTORY.createRemoteBooleanSetting("LOAD_PARTIAL_KEYWORDS", true, "SharingSettings.loadPartialKeywords");
    public static final StringSetting LAST_WARNED_SAVE_DIRECTORY = FACTORY.createStringSetting("LAST_WARNED_SAVED_DIRECTORY", "");

    private SharingSettings() {
    }

    public static final void setSaveDirectory(File saveDir) throws IOException {
        if (saveDir == null) {
            throw new NullPointerException();
        }
        if (!saveDir.isDirectory() && !saveDir.mkdirs()) {
            throw new IOException("could not create save dir");
        }
        String parentDir = saveDir.getParent();
        File incDir = new File(parentDir, "Incomplete");
        if (!incDir.isDirectory() && !incDir.mkdirs()) {
            throw new IOException("could not create incomplete dir");
        }
        FileUtils.setWriteable(saveDir);
        FileUtils.setWriteable(incDir);
        if (!(saveDir.canRead() && FileUtils.canWrite(saveDir) && incDir.canRead() && FileUtils.canWrite(incDir))) {
            throw new IOException("could not write to selected directory");
        }
        try {
            saveDir = FileUtils.getCanonicalFile(saveDir);
        }
        catch (IOException ignored) {
            // empty catch block
        }
        try {
            incDir = FileUtils.getCanonicalFile(incDir);
        }
        catch (IOException ignored) {
            // empty catch block
        }
        File snapFile = new File(incDir, "downloads.dat");
        try {
            snapFile = FileUtils.getCanonicalFile(snapFile);
        }
        catch (IOException ignored) {
            // empty catch block
        }
        File snapBackup = new File(incDir, "downloads.bak");
        try {
            snapBackup = FileUtils.getCanonicalFile(snapBackup);
        }
        catch (IOException ignored) {
            // empty catch block
        }
        DIRECTORY_FOR_SAVING_FILES.set(saveDir);
        INCOMPLETE_DIRECTORY.set(incDir);
        OLD_DOWNLOAD_SNAPSHOT_FILE.set(snapFile);
        OLD_DOWNLOAD_SNAPSHOT_BACKUP_FILE.set(snapBackup);
    }

    public static final File getSaveDirectory(Category category) {
        if (category == null) {
            return DIRECTORY_FOR_SAVING_FILES.get();
        }
        FileSetting fs = SharingSettings.getFileSettingForCategory(category);
        if (fs.isDefault()) {
            return DIRECTORY_FOR_SAVING_FILES.get();
        }
        return fs.get();
    }

    public static final File getSaveDirectory() {
        return DIRECTORY_FOR_SAVING_FILES.get();
    }

    public static final void setSubdirectoryLWSTemplate(String template) {
        if (template == null) {
            throw new NullPointerException();
        }
        TEMPLATE_SUBDIRECTORY_LWS_FILES.set(template);
    }

    public static final String getSubDirectoryLWSTemplate() {
        return TEMPLATE_SUBDIRECTORY_LWS_FILES.get();
    }

    public static final void setFileNameLWSTemplate(String template) {
        if (template == null) {
            throw new NullPointerException();
        }
        TEMPLATE_FOR_NAMING_LWS_FILES.set(template);
    }

    public static final String getFileNameLWSTemplate() {
        return TEMPLATE_FOR_NAMING_LWS_FILES.get();
    }

    public static final FileSetting getFileSettingForCategory(Category category) {
        String schema = category.getSchemaName();
        FileSetting setting = downloadDirsByDescription.get(schema);
        if (setting == null) {
            setting = FACTORY.createProxyFileSetting("DIRECTORY_FOR_SAVING_" + schema + "_FILES", DIRECTORY_FOR_SAVING_FILES);
            downloadDirsByDescription.put(schema, setting);
        }
        return setting;
    }

    private static File getLimeWireRootFolder() {
        String root = null;
        if (OSUtils.isWindows()) {
            root = SystemUtils.getSpecialPath(SystemUtils.SpecialLocations.DOCUMENTS);
        }
        if (root == null || "".equals(root)) {
            root = CommonUtils.getUserHomeDir().getPath();
        }
        return new File(root, "LimeWire");
    }

    @InspectableContainer
    private static class LazyInspectableContainer {
        @InspectablePrimitive(value="default download location changed", category=DataCategory.USAGE)
        private static final boolean locationChanged = !DIRECTORY_FOR_SAVING_FILES.get().equals(DEFAULT_SAVE_DIR);

        private LazyInspectableContainer() {
        }
    }
}

