/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.friend.impl.address;

import org.limewire.io.PermanentAddress;
import org.limewire.util.Objects;
import org.limewire.util.StringUtils;

public class FriendAddress
implements PermanentAddress {
    private final String id;
    private final String idPrefix;

    public static String parseIdPrefix(String id) {
        int slash = id.indexOf(47);
        if (slash == -1) {
            return id;
        }
        int endPrefix = Math.min(id.length(), slash + 6);
        return id.substring(0, endPrefix);
    }

    public FriendAddress(String id) {
        this(Objects.nonNull(id, "id"), FriendAddress.parseIdPrefix(id));
    }

    FriendAddress(String id, String idPrefix) {
        this.id = id;
        this.idPrefix = idPrefix;
    }

    public String getFullId() {
        return this.id;
    }

    @Override
    public String getAddressDescription() {
        return this.id;
    }

    public String getId() {
        return FriendAddress.parseBareAddress(this.id);
    }

    public String toString() {
        return StringUtils.toString(this, new Object[0]);
    }

    public static String parseBareAddress(String XMPPAddress) {
        if (XMPPAddress == null) {
            return null;
        }
        int slashIndex = XMPPAddress.indexOf("/");
        if (slashIndex < 0) {
            return XMPPAddress;
        }
        if (slashIndex == 0) {
            return "";
        }
        return XMPPAddress.substring(0, slashIndex);
    }

    @Override
    public int hashCode() {
        return this.idPrefix.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof FriendAddress)) {
            return false;
        }
        FriendAddress other = (FriendAddress)obj;
        return this.idPrefix.equals(other.idPrefix);
    }
}

