/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.geocode;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.util.EntityUtils;
import org.limewire.geocode.GeocodeInformation;
import org.limewire.geocode.GeocodeUrl;
import org.limewire.geocode.Geocoder;
import org.limewire.http.httpclient.LimeHttpClient;
import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;

final class GeocoderImpl
implements Geocoder {
    private static final Log LOG = LogFactory.getLog(GeocoderImpl.class);
    private final Provider<String> geoCodeURL;
    private final Provider<LimeHttpClient> httpClient;

    @Inject
    public GeocoderImpl(@GeocodeUrl Provider<String> geoCodeURL, Provider<LimeHttpClient> client) {
        this.geoCodeURL = geoCodeURL;
        this.httpClient = client;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GeocodeInformation getGeocodeInformation() {
        String url = this.geoCodeURL.get();
        if (url.isEmpty()) {
            return new GeocodeInformation();
        }
        HttpGet get = new HttpGet(url);
        LimeHttpClient client = this.httpClient.get();
        HttpResponse response = null;
        try {
            HttpEntity entity;
            response = client.execute(get);
            if (response.getStatusLine().getStatusCode() == 200 && (entity = response.getEntity()) != null) {
                String charset = EntityUtils.getContentCharSet(entity);
                GeocodeInformation geocodeInformation = this.parseGeoInfo(entity.getContent(), charset != null ? charset : "ISO-8859-1");
                return geocodeInformation;
            }
        }
        catch (IOException e) {
            LOG.debug("error parsing", e);
        }
        finally {
            client.releaseConnection(response);
        }
        return GeocodeInformation.EMPTY_GEO_INFO;
    }

    private GeocodeInformation parseGeoInfo(InputStream is, String charset) throws IOException {
        String line;
        GeocodeInformation res = new GeocodeInformation();
        String separator = "\t";
        BufferedReader in = new BufferedReader(new InputStreamReader(is, charset));
        while ((line = in.readLine()) != null) {
            String[] parts;
            if (line.isEmpty() || line.startsWith("#") || (parts = line.split(separator)).length < 2) continue;
            String name = parts[0];
            String value = parts[1];
            res.setProperty(name, value);
        }
        return res;
    }
}

