/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.http;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.apache.http.Header;
import org.apache.http.HttpMessage;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;
import org.limewire.util.URIUtils;

public class HttpCoreUtils {
    public static boolean hasHeaderListValue(HttpMessage message, String name, String token) {
        Header[] headers;
        for (Header header : headers = message.getHeaders(name)) {
            StringTokenizer t = new StringTokenizer(header.getValue(), ",");
            while (t.hasMoreTokens()) {
                if (!token.equals(t.nextToken().trim())) continue;
                return true;
            }
        }
        return false;
    }

    public static Map<String, String> parseQuery(String uriString, String encoding) {
        try {
            URI uri = URIUtils.toURI(uriString);
            return HttpCoreUtils.parseQuery(uri, encoding);
        }
        catch (URISyntaxException e) {
            return Collections.emptyMap();
        }
    }

    public static Map<String, String> parseQuery(URI uri, String encoding) {
        List<NameValuePair> list = URLEncodedUtils.parse(uri, encoding);
        if (list.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>(list.size());
        for (NameValuePair pair : list) {
            map.put(pair.getName(), pair.getValue());
        }
        return map;
    }
}

