/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.http.auth;

import java.util.StringTokenizer;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.message.BasicHeader;
import org.limewire.http.auth.Authenticator;
import org.limewire.http.auth.ServerAuthScheme;
import org.limewire.util.StringUtils;

public class BasicServerAuthScheme
implements ServerAuthScheme {
    private final Authenticator authenticator;
    private boolean complete;

    public BasicServerAuthScheme(Authenticator authenticator) {
        this.authenticator = authenticator;
    }

    @Override
    public void setComplete() {
        this.complete = true;
    }

    @Override
    public boolean isComplete() {
        return this.complete;
    }

    @Override
    public Credentials authenticate(HttpRequest request) {
        byte[] userNamePassword;
        UsernamePasswordCredentials credentials;
        StringTokenizer st;
        Header authHeader = request.getFirstHeader("Authorization");
        if (authHeader != null && (st = new StringTokenizer(authHeader.getValue())).hasMoreTokens() && st.nextToken().trim().equalsIgnoreCase("Basic") && st.hasMoreTokens() && this.authenticator.authenticate(credentials = new UsernamePasswordCredentials(StringUtils.getUTF8String(userNamePassword = Base64.decodeBase64(StringUtils.toUTF8Bytes(st.nextToken().trim())))))) {
            return credentials;
        }
        return null;
    }

    @Override
    public Header createChallenge() {
        return new BasicHeader("WWW-Authenticate", "Basic realm=\"secure\"");
    }
}

