/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.http.httpclient;

import com.google.inject.AbstractModule;
import com.google.inject.Provider;
import com.google.inject.Provides;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.http.client.HttpClient;
import org.apache.http.client.params.HttpClientParams;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.scheme.Scheme;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.conn.scheme.SocketFactory;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpConnectionParams;
import org.apache.http.params.HttpParams;
import org.limewire.http.httpclient.LimeHttpClient;
import org.limewire.http.httpclient.LimeHttpClientImpl;
import org.limewire.http.httpclient.ReapingClientConnectionManager;
import org.limewire.net.SocketsManager;
import org.limewire.nio.NBSocket;

public class LimeWireHttpClientModule
extends AbstractModule {
    private static final int CONNECTION_TIMEOUT = 5000;
    private static final int TIMEOUT = 8000;
    private static final int MAXIMUM_REDIRECTS = 10;

    @Override
    protected void configure() {
    }

    @Provides
    LimeHttpClient limeClient(@Named(value="nonBlockingConnectionManager") ReapingClientConnectionManager manager, @Named(value="defaults") Provider<HttpParams> defaultParams) {
        return new LimeHttpClientImpl(manager, defaultParams);
    }

    @Provides
    HttpClient simpleClient(Provider<LimeHttpClient> limeClient) {
        return limeClient.get();
    }

    @Provides
    @Named(value="limeSchemeRegistry")
    SchemeRegistry lsr(Provider<SocketsManager> socketsManager) {
        SchemeRegistry registry = new SchemeRegistry();
        registry.register(new Scheme("http", new LimeSocketFactory(socketsManager, SocketsManager.ConnectType.PLAIN), 80));
        registry.register(new Scheme("tls", new LimeSocketFactory(socketsManager, SocketsManager.ConnectType.TLS), 80));
        registry.register(new Scheme("https", new LimeSocketFactory(socketsManager, SocketsManager.ConnectType.SSL), 443));
        return registry;
    }

    @Provides
    @Singleton
    @Named(value="nonBlockingConnectionManager")
    ReapingClientConnectionManager nbcm(@Named(value="limeSchemeRegistry") Provider<SchemeRegistry> registry, @Named(value="backgroundExecutor") Provider<ScheduledExecutorService> scheduler, @Named(value="defaults") Provider<HttpParams> defaultParams) {
        return new ReapingClientConnectionManager(registry, scheduler, defaultParams);
    }

    @Provides
    @Named(value="defaults")
    HttpParams dp() {
        BasicHttpParams params = new BasicHttpParams();
        HttpConnectionParams.setConnectionTimeout(params, 5000);
        HttpConnectionParams.setSoTimeout(params, 8000);
        HttpClientParams.setRedirecting(params, true);
        params.setIntParameter("http.protocol.max-redirects", 10);
        return params;
    }

    private static class LimeSocketFactory
    implements SocketFactory {
        final Provider<SocketsManager> socketsManager;
        final SocketsManager.ConnectType type;

        public LimeSocketFactory(Provider<SocketsManager> socketsManager, SocketsManager.ConnectType type) {
            this.socketsManager = socketsManager;
            this.type = type;
        }

        @Override
        public Socket createSocket() throws IOException {
            return this.socketsManager.get().create(this.type);
        }

        @Override
        public Socket connectSocket(Socket socket, String targetHost, int targetPort, InetAddress localAddress, int localPort, HttpParams httpParams) throws IOException, UnknownHostException, ConnectTimeoutException {
            if (socket == null) {
                socket = this.createSocket();
            }
            InetSocketAddress localSocketAddr = null;
            if (localAddress != null && !localAddress.isAnyLocalAddress() || localPort > 0) {
                localSocketAddr = new InetSocketAddress(localAddress, localPort);
            }
            return this.socketsManager.get().connect((NBSocket)socket, localSocketAddr, new InetSocketAddress(targetHost, targetPort), HttpConnectionParams.getConnectionTimeout(httpParams), this.type);
        }

        @Override
        public boolean isSecure(Socket socket) throws IllegalArgumentException {
            return false;
        }
    }
}

