/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.io;

import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import org.limewire.io.Address;
import org.limewire.io.IpPort;

public interface Connectable
extends IpPort,
Address {
    public static final Comparator<Connectable> COMPARATOR = new Comparator<Connectable>(){

        @Override
        public int compare(Connectable o1, Connectable o2) {
            int ipPortdiff = IpPort.COMPARATOR.compare(o1, o2);
            if (ipPortdiff == 0) {
                if (o1.isTLSCapable() == o2.isTLSCapable()) {
                    return 0;
                }
                if (o1.isTLSCapable()) {
                    return 1;
                }
                return -1;
            }
            return ipPortdiff;
        }
    };
    public static final List<Connectable> EMPTY_LIST = Collections.emptyList();
    public static final Set<Connectable> EMPTY_SET = Collections.emptySet();

    public boolean isTLSCapable();
}

