/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.io;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.UnknownHostException;
import org.limewire.io.IpPort;
import org.limewire.io.NetworkInstanceUtils;
import org.limewire.io.NetworkUtils;

@Singleton
public class SimpleNetworkInstanceUtils
implements NetworkInstanceUtils {
    private final boolean localIsPrivate;

    @Inject
    public SimpleNetworkInstanceUtils() {
        this(true);
    }

    public SimpleNetworkInstanceUtils(boolean localIsPrivate) {
        this.localIsPrivate = localIsPrivate;
    }

    @Override
    public boolean isMe(byte[] address, int port) {
        return false;
    }

    @Override
    public boolean isMe(IpPort me) {
        return false;
    }

    @Override
    public boolean isMe(String host, int port) {
        return false;
    }

    @Override
    public boolean isPrivate() {
        return false;
    }

    @Override
    public boolean isPrivateAddress(byte[] address) {
        return this.localIsPrivate && NetworkUtils.isPrivateAddress(address);
    }

    @Override
    public boolean isPrivateAddress(InetAddress address) {
        return this.localIsPrivate && NetworkUtils.isPrivateAddress(address);
    }

    @Override
    public boolean isPrivateAddress(SocketAddress address) {
        return this.localIsPrivate && NetworkUtils.isPrivateAddress(((InetSocketAddress)address).getAddress());
    }

    @Override
    public boolean isPrivateAddress(String address) {
        try {
            return this.localIsPrivate && NetworkUtils.isPrivateAddress(InetAddress.getByName(address));
        }
        catch (UnknownHostException e) {
            return true;
        }
    }

    @Override
    public boolean isValidExternalIpPort(IpPort addr) {
        return NetworkUtils.isValidExternalIpPort(addr);
    }

    @Override
    public boolean isVeryCloseIP(byte[] addr) {
        return false;
    }

    @Override
    public boolean isVeryCloseIP(byte[] addr0, byte[] addr1) {
        return NetworkUtils.isVeryCloseIP(addr0, addr1);
    }

    @Override
    public boolean isVeryCloseIP(InetAddress addr) {
        return false;
    }
}

