/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.handler.response;

import java.io.IOException;
import java.net.SocketAddress;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.mojito.Context;
import org.limewire.mojito.KUID;
import org.limewire.mojito.exceptions.DHTBackendException;
import org.limewire.mojito.exceptions.DHTException;
import org.limewire.mojito.handler.response.AbstractResponseHandler;
import org.limewire.mojito.messages.RequestMessage;
import org.limewire.mojito.messages.ResponseMessage;
import org.limewire.mojito.messages.StatsResponse;
import org.limewire.mojito.result.StatsResult;

public class StatsResponseHandler
extends AbstractResponseHandler<StatsResult> {
    private static final Log LOG = LogFactory.getLog(StatsResponseHandler.class);

    public StatsResponseHandler(Context context) {
        super(context);
    }

    @Override
    protected void start() throws DHTException {
    }

    @Override
    protected void response(ResponseMessage message, long time) throws IOException {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Stats request to " + message.getContact() + " succeeded");
        }
        StatsResponse response = (StatsResponse)message;
        this.setReturnValue(new StatsResult(response.getStatistics()));
    }

    @Override
    protected void timeout(KUID nodeId, SocketAddress dst, RequestMessage message, long time) throws IOException {
        this.fireTimeoutException(nodeId, dst, message, time);
    }

    @Override
    protected void error(KUID nodeId, SocketAddress dst, RequestMessage message, IOException e) {
        this.setException(new DHTBackendException(nodeId, dst, message, e));
    }
}

