/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.manager;

import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.collection.CollectionUtils;
import org.limewire.concurrent.OnewayExchanger;
import org.limewire.concurrent.SyncWrapper;
import org.limewire.mojito.Context;
import org.limewire.mojito.KUID;
import org.limewire.mojito.concurrent.DHTTask;
import org.limewire.mojito.exceptions.DHTTimeoutException;
import org.limewire.mojito.handler.response.FindNodeResponseHandler;
import org.limewire.mojito.handler.response.PingResponseHandler;
import org.limewire.mojito.manager.BootstrapManager;
import org.limewire.mojito.manager.BootstrapWorker;
import org.limewire.mojito.manager.PingIteratorFactory;
import org.limewire.mojito.result.BootstrapResult;
import org.limewire.mojito.result.FindNodeResult;
import org.limewire.mojito.result.PingResult;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.routing.RouteTable;
import org.limewire.mojito.settings.BootstrapSettings;
import org.limewire.mojito.util.ContactUtils;
import org.limewire.mojito.util.RouteTableUtils;
import org.limewire.mojito.util.TimeAwareIterable;

class BootstrapProcess
implements DHTTask<BootstrapResult> {
    private static final Log LOG = LogFactory.getLog(BootstrapProcess.class);
    private OnewayExchanger<BootstrapResult, ExecutionException> exchanger;
    private final Context context;
    private final BootstrapManager manager;
    private final List<DHTTask<?>> tasks = new ArrayList();
    private final List<BootstrapWorker> workers = new ArrayList<BootstrapWorker>();
    private final SyncWrapper<Status> status = new SyncWrapper<Object>(null);
    private volatile boolean foundNewContacts = false;
    private int routeTableFailureCount;
    private boolean cancelled = false;
    private Iterator<KUID> bucketsToRefresh;
    private Contact node;
    private Set<? extends SocketAddress> dst;
    private long startTime = -1L;
    private final long waitOnLock;

    public BootstrapProcess(Context context, BootstrapManager manager, Contact node) {
        this.context = context;
        this.manager = manager;
        this.node = node;
        this.waitOnLock = BootstrapSettings.getWaitOnLock(true);
    }

    public BootstrapProcess(Context context, BootstrapManager manager, Set<? extends SocketAddress> dst) {
        this.context = context;
        this.manager = manager;
        this.dst = dst;
        this.waitOnLock = BootstrapSettings.getWaitOnLock(false);
    }

    @Override
    public long getWaitOnLockTimeout() {
        return this.waitOnLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void start(OnewayExchanger<BootstrapResult, ExecutionException> exchanger) {
        Object object = this.status.getLock();
        synchronized (object) {
            if (this.status.get() != null) {
                return;
            }
            this.status.set(Status.BOOTSTRAPPING);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("starting bootstrap " + this.getPercentage(this.context.getRouteTable()) + "% alive");
        }
        if (exchanger == null) {
            if (LOG.isWarnEnabled()) {
                LOG.warn("Starting ResponseHandler without an OnewayExchanger");
            }
            exchanger = new OnewayExchanger(true);
        }
        this.exchanger = exchanger;
        this.startTime = System.currentTimeMillis();
        if (this.node == null) {
            this.findInitialContact();
        } else {
            this.findNearestNodes();
        }
    }

    private void findInitialContact() {
        OnewayExchanger<PingResult, ExecutionException> c = new OnewayExchanger<PingResult, ExecutionException>(true){

            @Override
            public synchronized void setValue(PingResult value) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Found initial bootstrap Node: " + value);
                }
                super.setValue(value);
                BootstrapProcess.this.handlePong(value);
            }

            @Override
            public synchronized void setException(ExecutionException exception) {
                LOG.info("ExecutionException", exception);
                super.setException(exception);
                BootstrapProcess.this.exchanger.setException(exception);
            }
        };
        PingResponseHandler handler = new PingResponseHandler(this.context, new PingIteratorFactory.SocketAddressPinger(this.dst));
        handler.setMaxErrors(0);
        this.start(handler, c);
    }

    private void handlePong(PingResult result) {
        this.node = result.getContact();
        this.findNearestNodes();
    }

    private void findNearestNodes() {
        OnewayExchanger<FindNodeResult, ExecutionException> c = new OnewayExchanger<FindNodeResult, ExecutionException>(true){

            @Override
            public synchronized void setValue(FindNodeResult value) {
                if (LOG.isTraceEnabled()) {
                    LOG.trace("Found nearest Nodes: " + value);
                }
                super.setValue(value);
                BootstrapProcess.this.handleNearestNodes(value);
            }

            @Override
            public synchronized void setException(ExecutionException exception) {
                super.setException(exception);
                BootstrapProcess.this.handleExecutionException(exception);
            }
        };
        FindNodeResponseHandler handler = new FindNodeResponseHandler(this.context, this.node, this.context.getLocalNodeID());
        this.start(handler, c);
    }

    void handleExecutionException(ExecutionException ee) {
        LOG.info("ExecutionException", ee);
        this.exchanger.setException(ee);
    }

    private void handleNearestNodes(FindNodeResult result) {
        Collection<? extends Contact> collisions = result.getCollisions();
        if (!collisions.isEmpty()) {
            this.checkCollisions(collisions);
        } else {
            Collection<? extends Contact> path = result.getPath();
            if (path == null || path.isEmpty()) {
                this.bootstrapped(false);
            } else if (path.size() == 1 && path.contains(this.context.getLocalNode())) {
                this.bootstrapped(false);
            } else {
                this.refreshAllBuckets();
            }
        }
    }

    private void checkCollisions(Collection<? extends Contact> collisions) {
        OnewayExchanger<PingResult, ExecutionException> c = new OnewayExchanger<PingResult, ExecutionException>(true){

            @Override
            public synchronized void setValue(PingResult value) {
                if (LOG.isErrorEnabled()) {
                    LOG.error(BootstrapProcess.this.context.getLocalNode() + " collides with " + value.getContact());
                }
                super.setValue(value);
                BootstrapProcess.this.handleCollision(value);
            }

            @Override
            public synchronized void setException(ExecutionException exception) {
                LOG.info("ExecutionException", exception);
                super.setException(exception);
                Throwable cause = exception.getCause();
                if (cause instanceof DHTTimeoutException) {
                    BootstrapProcess.this.refreshAllBuckets();
                } else {
                    BootstrapProcess.this.exchanger.setException(exception);
                }
            }
        };
        Contact sender = ContactUtils.createCollisionPingSender(this.context.getLocalNode());
        PingIteratorFactory.CollisionPinger pinger = new PingIteratorFactory.CollisionPinger(this.context, sender, CollectionUtils.toSet(collisions));
        PingResponseHandler handler = new PingResponseHandler(this.context, sender, pinger);
        this.start(handler, c);
    }

    private void handleCollision(PingResult result) {
        this.context.changeNodeID();
        this.findNearestNodes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void refreshAllBuckets() {
        this.routeTableFailureCount = 0;
        this.foundNewContacts = false;
        Collection<KUID> bucketIds = this.getBucketsToRefresh();
        if (LOG.isTraceEnabled()) {
            LOG.trace("Buckets to refresh: " + org.limewire.mojito.util.CollectionUtils.toString(bucketIds));
        }
        this.bucketsToRefresh = new TimeAwareIterable<KUID>(BootstrapSettings.BOOTSTRAP_TIMEOUT.getValue(), bucketIds).iterator();
        for (int i = 0; i < BootstrapSettings.BOOTSTRAP_WORKERS.getValue(); ++i) {
            BootstrapWorker worker = new BootstrapWorker(this.context, this);
            BootstrapProcess bootstrapProcess = this;
            synchronized (bootstrapProcess) {
                this.workers.add(worker);
            }
            this.context.getDHTExecutorService().execute(worker);
        }
    }

    private Collection<KUID> getBucketsToRefresh() {
        List<KUID> bucketIds = CollectionUtils.toList(this.context.getRouteTable().getRefreshIDs(true));
        Collections.reverse(bucketIds);
        return bucketIds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    KUID getNextBucket() {
        Object object;
        BootstrapProcess bootstrapProcess = this;
        synchronized (bootstrapProcess) {
            if (this.cancelled) {
                return null;
            }
            object = this.bucketsToRefresh;
            synchronized (object) {
                if (this.bucketsToRefresh.hasNext()) {
                    return this.bucketsToRefresh.next();
                }
            }
        }
        boolean determinate = false;
        object = this.status.getLock();
        synchronized (object) {
            if (this.status.get() != Status.FINISHED) {
                this.status.set(Status.FINISHED);
                determinate = true;
            }
        }
        if (determinate) {
            this.determinateIfBootstrapped();
        }
        return null;
    }

    private void handleStaleRouteTable() {
        LOG.debug("handling stale route table");
        this.context.getRouteTable().purge(RouteTable.PurgeMode.DROP_CACHE, RouteTable.PurgeMode.PURGE_CONTACTS, RouteTable.PurgeMode.MERGE_BUCKETS, RouteTable.PurgeMode.STATE_TO_UNKNOWN);
        this.findNearestNodes();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void refreshDone(int failures, boolean newContacts) {
        this.foundNewContacts |= newContacts;
        boolean retry = false;
        boolean terminate = false;
        Object object = this.status.getLock();
        synchronized (object) {
            boolean highFailures = false;
            switch (this.status.get()) {
                case BOOTSTRAPPING: 
                case RETRYING_BOOTSTRAP: {
                    this.routeTableFailureCount += failures;
                    if (this.routeTableFailureCount < BootstrapSettings.MAX_BOOTSTRAP_FAILURES.getValue()) break;
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("high failures: " + this.routeTableFailureCount);
                    }
                    highFailures = true;
                }
            }
            if (highFailures) {
                switch (this.status.get()) {
                    case BOOTSTRAPPING: {
                        this.routeTableFailureCount = 0;
                        this.status.set(Status.RETRYING_BOOTSTRAP);
                        retry = true;
                        break;
                    }
                    case RETRYING_BOOTSTRAP: {
                        terminate = true;
                        this.status.set(Status.FINISHED);
                    }
                }
            }
        }
        if (retry) {
            this.handleStaleRouteTable();
        }
        if (terminate) {
            this.cancel();
            this.determinateIfBootstrapped();
        }
    }

    private void determinateIfBootstrapped() {
        boolean bootstrapped = false;
        float alive = this.purgeAndGetPercenetage();
        if (alive >= BootstrapSettings.IS_BOOTSTRAPPED_RATIO.getValue()) {
            bootstrapped = true;
        }
        if (LOG.isTraceEnabled()) {
            LOG.trace("Bootstrapped: " + alive + " >= " + BootstrapSettings.IS_BOOTSTRAPPED_RATIO.getValue() + " -> " + bootstrapped);
        }
        this.bootstrapped(bootstrapped);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private float purgeAndGetPercenetage() {
        RouteTable routeTable;
        RouteTable routeTable2 = routeTable = this.context.getRouteTable();
        synchronized (routeTable2) {
            routeTable.purge(RouteTable.PurgeMode.DROP_CACHE, RouteTable.PurgeMode.PURGE_CONTACTS, RouteTable.PurgeMode.MERGE_BUCKETS);
            return this.getPercentage(routeTable);
        }
    }

    private float getPercentage(RouteTable table) {
        return RouteTableUtils.getPercentageOfAliveContacts(table);
    }

    private void bootstrapped(boolean bootstrapped) {
        if (LOG.isTraceEnabled()) {
            LOG.trace("Finishing bootstrapping: " + bootstrapped);
        }
        BootstrapResult.ResultType type = BootstrapResult.ResultType.BOOTSTRAP_FAILED;
        if (bootstrapped) {
            this.manager.setBootstrapped(true);
            type = BootstrapResult.ResultType.BOOTSTRAP_SUCCEEDED;
        }
        long time = System.currentTimeMillis() - this.startTime;
        this.exchanger.setValue(new BootstrapResult(this.node, time, type));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void start(DHTTask<T> task, OnewayExchanger<T, ExecutionException> c) {
        boolean doStart = false;
        BootstrapProcess bootstrapProcess = this;
        synchronized (bootstrapProcess) {
            if (!this.cancelled) {
                this.tasks.add(task);
                doStart = true;
            }
        }
        if (doStart) {
            task.start(c);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancel() {
        this.status.set(Status.FINISHED);
        if (LOG.isTraceEnabled()) {
            LOG.trace("Canceling BootstrapProcess");
        }
        ArrayList copy = null;
        ArrayList<BootstrapWorker> workerCopy = null;
        BootstrapProcess bootstrapProcess = this;
        synchronized (bootstrapProcess) {
            if (!this.cancelled) {
                copy = new ArrayList(this.tasks);
                this.tasks.clear();
                workerCopy = new ArrayList<BootstrapWorker>(this.workers);
                this.workers.clear();
                this.cancelled = true;
            }
        }
        if (copy != null) {
            for (DHTTask dHTTask : copy) {
                dHTTask.cancel();
            }
        }
        if (workerCopy != null) {
            for (BootstrapWorker bootstrapWorker : workerCopy) {
                bootstrapWorker.shutdown();
            }
        }
    }

    private static enum Status {
        BOOTSTRAPPING,
        RETRYING_BOOTSTRAP,
        FINISHED;

    }
}

