/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.manager;

import java.net.SocketAddress;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import org.limewire.mojito.Context;
import org.limewire.mojito.KUID;
import org.limewire.mojito.concurrent.DHTFuture;
import org.limewire.mojito.concurrent.DHTFutureTask;
import org.limewire.mojito.concurrent.DHTTask;
import org.limewire.mojito.handler.response.PingResponseHandler;
import org.limewire.mojito.manager.AbstractManager;
import org.limewire.mojito.manager.PingIteratorFactory;
import org.limewire.mojito.result.PingResult;
import org.limewire.mojito.routing.Contact;
import org.limewire.mojito.statistics.NetworkStatisticContainer;
import org.limewire.mojito.util.ContactUtils;

public class PingManager
extends AbstractManager<PingResult> {
    private final Map<SocketAddress, PingFuture> futureMap = Collections.synchronizedMap(new HashMap());
    private NetworkStatisticContainer networkStats;

    public PingManager(Context context) {
        super(context);
        this.networkStats = context.getNetworkStats();
    }

    public void init() {
        this.futureMap.clear();
    }

    public DHTFuture<PingResult> ping(SocketAddress host) {
        PingIteratorFactory.SocketAddressPinger pinger = new PingIteratorFactory.SocketAddressPinger(host);
        return this.ping(null, host, pinger);
    }

    public DHTFuture<PingResult> pingAddresses(Set<? extends SocketAddress> hosts) {
        PingIteratorFactory.SocketAddressPinger pinger = new PingIteratorFactory.SocketAddressPinger(hosts);
        return this.ping(null, null, pinger);
    }

    public DHTFuture<PingResult> ping(Contact node) {
        PingIteratorFactory.ContactPinger pinger = new PingIteratorFactory.ContactPinger(node);
        return this.ping(null, node.getContactAddress(), pinger);
    }

    public DHTFuture<PingResult> ping(KUID nodeId, SocketAddress address) {
        PingIteratorFactory.EntryPinger pinger = new PingIteratorFactory.EntryPinger(nodeId, address);
        return this.ping(null, address, pinger);
    }

    public DHTFuture<PingResult> ping(Set<? extends Contact> nodes) {
        PingIteratorFactory.ContactPinger pinger = new PingIteratorFactory.ContactPinger(nodes);
        return this.ping(null, null, pinger);
    }

    public DHTFuture<PingResult> collisionPing(Contact node) {
        return this.collisionPing(node.getContactAddress(), Collections.singleton(node));
    }

    public DHTFuture<PingResult> collisionPing(Set<? extends Contact> nodes) {
        return this.collisionPing(null, nodes);
    }

    private DHTFuture<PingResult> collisionPing(SocketAddress key, Set<? extends Contact> nodes) {
        Contact sender = ContactUtils.createCollisionPingSender(this.context.getLocalNode());
        PingIteratorFactory.CollisionPinger pinger = new PingIteratorFactory.CollisionPinger(this.context, sender, nodes);
        return this.ping(sender, key, pinger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DHTFuture<PingResult> ping(Contact sender, SocketAddress key, PingResponseHandler.PingIterator pinger) {
        PingFuture future = null;
        Map<SocketAddress, PingFuture> map = this.futureMap;
        synchronized (map) {
            PingFuture pingFuture = future = key != null ? this.futureMap.get(key) : null;
            if (future == null) {
                PingResponseHandler handler = new PingResponseHandler(this.context, sender, pinger);
                future = new PingFuture(key, handler);
                if (key != null) {
                    this.futureMap.put(key, future);
                }
                this.networkStats.PINGS_SENT.incrementStat();
                this.context.getDHTExecutorService().execute(future);
            }
        }
        return future;
    }

    private class PingFuture
    extends DHTFutureTask<PingResult> {
        private final SocketAddress key;

        public PingFuture(SocketAddress key, DHTTask<PingResult> handler) {
            super(PingManager.this.context, handler);
            this.key = key;
        }

        @Override
        protected void done() {
            if (this.key != null) {
                PingManager.this.futureMap.remove(this.key);
            }
        }

        @Override
        protected void fireFutureResult(PingResult value) {
            ((PingManager)PingManager.this).networkStats.PINGS_OK.incrementStat();
            super.fireFutureResult(value);
        }

        @Override
        protected void fireExecutionException(ExecutionException e) {
            ((PingManager)PingManager.this).networkStats.PINGS_FAILED.incrementStat();
            super.fireExecutionException(e);
        }
    }
}

