/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.mojito.visual;

import java.awt.Color;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.geom.Rectangle2D;
import java.lang.reflect.InvocationTargetException;
import java.net.SocketAddress;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.limewire.mojito.Context;
import org.limewire.mojito.KUID;
import org.limewire.mojito.io.MessageDispatcher;
import org.limewire.mojito.messages.DHTMessage;
import org.limewire.mojito.messages.RequestMessage;
import org.limewire.mojito.visual.DartBoard;
import org.limewire.mojito.visual.Painter;
import org.limewire.mojito.visual.PlasmaLamp;
import org.limewire.mojito.visual.SnowMan;

public class ArcsVisualizer
extends JPanel
implements MessageDispatcher.MessageDispatcherListener {
    private static final int SLEEP = 100;
    private static final float FONT_SIZE = 24.0f;
    private final Context context;
    private Timer timer;
    private final Object lock = new Object();
    private Painter painter;
    private int painterIndex = 0;
    private final List<Painter> painters = new ArrayList<Painter>();

    public static ArcsVisualizer show(final Context context) {
        final ArcsVisualizer arcs = new ArcsVisualizer(context, context.getLocalNodeID());
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JFrame frame = new JFrame(context.getName());
                frame.getContentPane().add(arcs);
                frame.setBounds(20, 30, 640, 640);
                frame.addWindowListener(new WindowAdapter(){

                    @Override
                    public void windowClosing(WindowEvent e) {
                        arcs.stopArcs();
                    }
                });
                frame.setVisible(true);
            }
        });
        arcs.startArcs();
        return arcs;
    }

    public void startArcs() {
        this.timer.start();
        this.context.getMessageDispatcher().addMessageDispatcherListener(this);
    }

    public void stopArcs() {
        this.timer.stop();
        this.context.getMessageDispatcher().removeMessageDispatcherListener(this);
    }

    public ArcsVisualizer(Context context, KUID nodeId) {
        this.context = context;
        this.addPainter(new SnowMan(nodeId));
        this.addPainter(new PlasmaLamp(nodeId));
        this.addPainter(new DartBoard(nodeId));
        this.painter = this.painters.get(this.painterIndex);
        Runnable runner = new Runnable(){

            @Override
            public void run() {
                ArcsVisualizer.this.timer = new Timer(100, new ActionListener(){

                    @Override
                    public void actionPerformed(ActionEvent e) {
                        ArcsVisualizer.this.repaint();
                    }
                });
                ArcsVisualizer.this.setFocusable(true);
                ArcsVisualizer.this.addMouseListener(new MouseAdapter(){
                    private volatile boolean hadFocus = false;

                    @Override
                    public void mousePressed(MouseEvent e) {
                        this.hadFocus = e.getComponent().isFocusOwner();
                        if (!this.hadFocus) {
                            ArcsVisualizer.this.requestFocusInWindow();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void mouseClicked(MouseEvent e) {
                        if (!this.hadFocus) {
                            return;
                        }
                        Object object = ArcsVisualizer.this.lock;
                        synchronized (object) {
                            ArcsVisualizer.this.painter.clear();
                            ArcsVisualizer.this.painterIndex = (ArcsVisualizer.this.painterIndex + 1) % ArcsVisualizer.this.painters.size();
                            ArcsVisualizer.this.painter = (Painter)ArcsVisualizer.this.painters.get(ArcsVisualizer.this.painterIndex);
                        }
                    }
                });
            }
        };
        if (SwingUtilities.isEventDispatchThread()) {
            runner.run();
        } else {
            try {
                SwingUtilities.invokeAndWait(runner);
            }
            catch (InterruptedException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPainter(Painter painter) {
        Object object = this.lock;
        synchronized (object) {
            this.painters.add(painter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        float width = this.getWidth();
        float height = this.getHeight();
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setColor(Color.black);
        g2.fill(new Rectangle2D.Float(0.0f, 0.0f, width, height));
        g2.setFont(this.getFont().deriveFont(24.0f));
        g2.setColor(Color.green);
        FontMetrics fm = g2.getFontMetrics();
        g2.drawString("Input", width / 4.0f - (float)fm.stringWidth("Input") / 2.0f, 30.0f);
        g2.setColor(Color.red);
        g2.drawString("Output", width - width / 4.0f - (float)fm.stringWidth("Output") / 2.0f, 30.0f);
        g2.setFont(this.getFont().deriveFont(12.0f));
        fm = g2.getFontMetrics();
        g2.setColor(new Color(0, 255, 0));
        g2.drawString("response", width / 4.0f - (float)fm.stringWidth("response") / 2.0f, 48.0f);
        g2.setColor(new Color(0, 255, 255));
        g2.drawString("request", width / 4.0f - (float)fm.stringWidth("request") / 2.0f, 60.0f);
        g2.setColor(new Color(255, 0, 0));
        g2.drawString("request", width - width / 4.0f - (float)fm.stringWidth("request") / 2.0f, 48.0f);
        g2.setColor(new Color(255, 0, 255));
        g2.drawString("response", width - width / 4.0f - (float)fm.stringWidth("response") / 2.0f, 60.0f);
        Object object = this.lock;
        synchronized (object) {
            this.painter.paint(this, g2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleMessageDispatcherEvent(MessageDispatcher.MessageDispatcherEvent evt) {
        MessageDispatcher.MessageDispatcherEvent.EventType type = evt.getEventType();
        KUID nodeId = null;
        SocketAddress addr = null;
        if (type.equals((Object)MessageDispatcher.MessageDispatcherEvent.EventType.MESSAGE_RECEIVED)) {
            nodeId = evt.getMessage().getContact().getNodeID();
            addr = evt.getMessage().getContact().getContactAddress();
        } else if (type.equals((Object)MessageDispatcher.MessageDispatcherEvent.EventType.MESSAGE_SENT)) {
            nodeId = evt.getNodeID();
            addr = evt.getSocketAddress();
        } else {
            return;
        }
        DHTMessage.OpCode opcode = evt.getMessage().getOpCode();
        boolean request = evt.getMessage() instanceof RequestMessage;
        Object object = this.lock;
        synchronized (object) {
            this.painter.handle(type, nodeId, addr, opcode, request);
        }
    }

    public static void main(String[] args) throws Exception {
        ArcsVisualizer arcs = new ArcsVisualizer(null, KUID.createRandomID());
        JFrame frame = new JFrame();
        frame.getContentPane().add(arcs);
        frame.setBounds(20, 30, 640, 480);
        frame.setVisible(true);
        Random generator = new Random();
        MessageDispatcher.MessageDispatcherEvent.EventType type = null;
        KUID nodeId = null;
        int sleep = 100;
        while (true) {
            nodeId = KUID.createRandomID();
            type = generator.nextBoolean() ? MessageDispatcher.MessageDispatcherEvent.EventType.MESSAGE_RECEIVED : MessageDispatcher.MessageDispatcherEvent.EventType.MESSAGE_SENT;
            DHTMessage.OpCode opcode = DHTMessage.OpCode.valueOf(1 + generator.nextInt(DHTMessage.OpCode.values().length - 1));
            arcs.painter.handle(type, nodeId, null, opcode, true);
            Thread.sleep(generator.nextInt(100));
            if (!generator.nextBoolean()) continue;
            if (type.equals((Object)MessageDispatcher.MessageDispatcherEvent.EventType.MESSAGE_SENT)) {
                arcs.painter.handle(MessageDispatcher.MessageDispatcherEvent.EventType.MESSAGE_RECEIVED, nodeId, null, opcode, false);
                continue;
            }
            arcs.painter.handle(MessageDispatcher.MessageDispatcherEvent.EventType.MESSAGE_SENT, nodeId, null, opcode, false);
        }
    }
}

