/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.nio.InterruptedIOException;
import org.limewire.nio.NBSocket;
import org.limewire.nio.NIODispatcher;
import org.limewire.nio.NIOInputStream;
import org.limewire.nio.NIOOutputStream;
import org.limewire.nio.NoOpReader;
import org.limewire.nio.NoOpWriter;
import org.limewire.nio.RequiresSelectionKeyAttachment;
import org.limewire.nio.channel.ChannelReadObserver;
import org.limewire.nio.channel.ChannelReader;
import org.limewire.nio.channel.ChannelWriter;
import org.limewire.nio.channel.InterestReadableByteChannel;
import org.limewire.nio.channel.InterestWritableByteChannel;
import org.limewire.nio.channel.NIOMultiplexor;
import org.limewire.nio.channel.ThrottleReader;
import org.limewire.nio.observer.ConnectObserver;
import org.limewire.nio.observer.ReadWriteObserver;
import org.limewire.nio.observer.Shutdownable;
import org.limewire.nio.observer.WriteObserver;
import org.limewire.nio.timeout.ReadTimeout;
import org.limewire.nio.timeout.SoTimeout;

public abstract class AbstractNBSocket
extends NBSocket
implements ConnectObserver,
ReadWriteObserver,
NIOMultiplexor,
ReadTimeout,
SoTimeout {
    private static final Log LOG = LogFactory.getLog(AbstractNBSocket.class);
    private final Object LOCK = new Object();
    private volatile ChannelReadObserver reader;
    private volatile ThrottleReader throttleReader;
    private volatile WriteObserver writer;
    private volatile NIOOutputStream nioOutputStream;
    private volatile ConnectObserver connecter;
    private volatile Shutdownable shutdownObserver;
    private boolean shutdown = false;

    protected abstract InterestReadableByteChannel getBaseReadChannel();

    protected abstract InterestWritableByteChannel getBaseWriteChannel();

    protected abstract void shutdownImpl();

    public final void setInitialReader() {
        this.reader = new NIOInputStream(this, this, this.getBaseReadChannel());
    }

    public final void setInitialWriter() {
        InterestWritableByteChannel base = this.getBaseWriteChannel();
        this.writer = this.getBottomFromChain(base);
        this.nioOutputStream = new NIOOutputStream(this, base);
    }

    private InterestWritableByteChannel getBottomFromChain(InterestWritableByteChannel top) {
        if (top instanceof ChannelWriter) {
            ChannelWriter lastChannel = (ChannelWriter)((Object)top);
            while (lastChannel.getWriteChannel() instanceof ChannelWriter) {
                lastChannel = (ChannelWriter)((Object)lastChannel.getWriteChannel());
            }
            return (InterestWritableByteChannel)((Object)lastChannel);
        }
        return top;
    }

    @Override
    public final void setShutdownObserver(Shutdownable observer) {
        this.shutdownObserver = observer;
    }

    public final void setReadThrottleChannel(final ThrottleReader newThrottle) {
        NIODispatcher.instance().getScheduledExecutorService().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Object object = AbstractNBSocket.this.LOCK;
                synchronized (object) {
                    if (AbstractNBSocket.this.shutdown) {
                        return;
                    }
                }
                assert (AbstractNBSocket.this.throttleReader == null);
                assert (newThrottle != null);
                AbstractNBSocket.this.throttleReader = newThrottle;
                AbstractNBSocket.this.throttleReader.setAttachment(AbstractNBSocket.this);
                AbstractNBSocket.this.installThrottle(AbstractNBSocket.this.throttleReader, AbstractNBSocket.this.reader);
            }
        });
    }

    protected void installThrottle(ThrottleReader throttle, ChannelReader reader) {
        ChannelReader lastChannel = reader;
        while (lastChannel.getReadChannel() instanceof ChannelReader) {
            lastChannel = (ChannelReader)((Object)lastChannel.getReadChannel());
        }
        if (throttle != lastChannel) {
            lastChannel.setReadChannel(throttle);
            throttle.setReadChannel(this.getBaseReadChannel());
        }
    }

    @Override
    public final void setReadObserver(final ChannelReadObserver newReader) {
        NIODispatcher.instance().getScheduledExecutorService().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                ChannelReadObserver oldReader = AbstractNBSocket.this.reader;
                try {
                    Object object = AbstractNBSocket.this.LOCK;
                    synchronized (object) {
                        if (AbstractNBSocket.this.shutdown) {
                            newReader.shutdown();
                            return;
                        }
                        AbstractNBSocket.this.reader = newReader;
                    }
                    ChannelReader lastChannel = newReader;
                    while (lastChannel.getReadChannel() instanceof ChannelReader) {
                        lastChannel = (ChannelReader)((Object)lastChannel.getReadChannel());
                    }
                    if (lastChannel instanceof RequiresSelectionKeyAttachment) {
                        ((RequiresSelectionKeyAttachment)((Object)lastChannel)).setAttachment(AbstractNBSocket.this);
                    }
                    if (oldReader instanceof InterestReadableByteChannel && oldReader != newReader) {
                        lastChannel.setReadChannel((InterestReadableByteChannel)((Object)oldReader));
                        AbstractNBSocket.this.reader.handleRead();
                        oldReader.shutdown();
                    }
                    InterestReadableByteChannel source = AbstractNBSocket.this.getBaseReadChannel();
                    lastChannel.setReadChannel(source);
                    if (AbstractNBSocket.this.throttleReader != null) {
                        AbstractNBSocket.this.installThrottle(AbstractNBSocket.this.throttleReader, AbstractNBSocket.this.reader);
                    }
                    source.interestRead(true);
                    if (AbstractNBSocket.this.isConnected() && !NIODispatcher.instance().isReadReadyThisIteration(AbstractNBSocket.this.getChannel())) {
                        AbstractNBSocket.this.reader.handleRead();
                    }
                }
                catch (IOException iox) {
                    AbstractNBSocket.this.shutdown();
                    oldReader.shutdown();
                }
            }
        });
    }

    @Override
    public final void setWriteObserver(final ChannelWriter newWriter) {
        NIODispatcher.instance().getScheduledExecutorService().execute(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    if (AbstractNBSocket.this.writer.handleWrite()) {
                        throw new IllegalStateException("data still in old writer!");
                    }
                    AbstractNBSocket.this.writer.shutdown();
                    if (AbstractNBSocket.this.nioOutputStream != null) {
                        AbstractNBSocket.this.nioOutputStream.shutdown();
                    }
                    ChannelWriter lastChannel = newWriter;
                    while (lastChannel.getWriteChannel() instanceof ChannelWriter) {
                        if (!((lastChannel = (ChannelWriter)((Object)lastChannel.getWriteChannel())) instanceof RequiresSelectionKeyAttachment)) continue;
                        ((RequiresSelectionKeyAttachment)((Object)lastChannel)).setAttachment(AbstractNBSocket.this);
                    }
                    InterestWritableByteChannel source = AbstractNBSocket.this.getBaseWriteChannel();
                    Object object = AbstractNBSocket.this.LOCK;
                    synchronized (object) {
                        lastChannel.setWriteChannel(source);
                        if (AbstractNBSocket.this.shutdown) {
                            source.shutdown();
                            return;
                        }
                        AbstractNBSocket.this.nioOutputStream = null;
                        AbstractNBSocket.this.writer = AbstractNBSocket.this.getBottomFromChain(source);
                    }
                }
                catch (IOException iox) {
                    AbstractNBSocket.this.shutdown();
                    newWriter.shutdown();
                }
            }
        });
    }

    @Override
    public final void handleConnect(Socket s) throws IOException {
        ConnectObserver observer = this.connecter;
        this.connecter = null;
        observer.handleConnect(this);
    }

    @Override
    public final void handleRead() throws IOException {
        this.reader.handleRead();
    }

    @Override
    public final boolean handleWrite() throws IOException {
        return this.writer.handleWrite();
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    @Override
    public final void connect(SocketAddress addr) throws IOException {
        this.connect(addr, 0);
    }

    @Override
    public final void connect(SocketAddress addr, int timeout) throws IOException {
        if (timeout < 0) {
            throw new IllegalArgumentException("timeout must not be < 0");
        }
        final CountDownLatch connectLatch = new CountDownLatch(1);
        ConnectObserver connecter = new ConnectObserver(){

            @Override
            public void handleConnect(Socket s) {
                connectLatch.countDown();
            }

            @Override
            public void shutdown() {
                connectLatch.countDown();
            }

            @Override
            public void handleIOException(IOException e) {
            }
        };
        if (!this.connect(addr, timeout, connecter)) {
            long then = System.currentTimeMillis();
            try {
                if (timeout == 0) {
                    connectLatch.await();
                } else {
                    connectLatch.await(timeout + 1000, TimeUnit.MILLISECONDS);
                }
            }
            catch (InterruptedException ie) {
                this.shutdown();
                throw new InterruptedIOException(ie);
            }
            if (!this.isConnected()) {
                this.shutdown();
                long now = System.currentTimeMillis();
                if (timeout != 0 && now - then >= (long)timeout) {
                    throw new SocketTimeoutException("operation timed out (" + timeout + ")");
                }
                throw new ConnectException("Unable to connect!");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean connect(SocketAddress addr, int timeout, final ConnectObserver observer) {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.shutdown) {
                observer.shutdown();
                return false;
            }
            this.connecter = observer;
        }
        try {
            InetSocketAddress iaddr = (InetSocketAddress)addr;
            if (iaddr.isUnresolved()) {
                throw new IOException("unresolved: " + addr);
            }
            if (this.getChannel().connect(addr)) {
                NIODispatcher.instance().getScheduledExecutorService().execute(new Runnable(){

                    @Override
                    public void run() {
                        NIODispatcher.instance().register(AbstractNBSocket.this.getChannel(), AbstractNBSocket.this);
                        try {
                            observer.handleConnect(AbstractNBSocket.this);
                        }
                        catch (IOException iox) {
                            NIODispatcher.instance().executeLaterAlways(new Runnable(){

                                @Override
                                public void run() {
                                    AbstractNBSocket.this.shutdown();
                                }
                            });
                        }
                    }
                });
                return true;
            }
            NIODispatcher.instance().registerConnect(this.getChannel(), this, timeout);
            return false;
        }
        catch (IOException failed) {
            NIODispatcher.instance().executeLaterAlways(new Runnable(){

                @Override
                public void run() {
                    AbstractNBSocket.this.shutdown();
                }
            });
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final InputStream getInputStream() throws IOException {
        ChannelReadObserver localReader;
        if (this.isClosed() || this.isShutdown()) {
            throw new IOException("Socket closed.");
        }
        Object object = this.LOCK;
        synchronized (object) {
            if (this.isShutdown()) {
                throw new IOException("Socket closed.");
            }
            localReader = this.reader;
        }
        if (localReader instanceof NIOInputStream) {
            NIOInputStream nis = (NIOInputStream)localReader;
            InputStream stream = nis.getInputStream();
            nis.interestRead(true);
            return stream;
        }
        Callable<InputStream> callable = new Callable<InputStream>(){

            @Override
            public InputStream call() throws IOException {
                NIOInputStream stream = new NIOInputStream(AbstractNBSocket.this, AbstractNBSocket.this, null).init();
                AbstractNBSocket.this.setReadObserver(stream);
                return stream.getInputStream();
            }
        };
        Future<InputStream> future = NIODispatcher.instance().getScheduledExecutorService().submit(callable);
        try {
            return future.get();
        }
        catch (ExecutionException ee) {
            throw (IOException)new IOException().initCause(ee.getCause());
        }
        catch (InterruptedException ie) {
            throw (IOException)new IOException().initCause(ie.getCause());
        }
    }

    @Override
    public final OutputStream getOutputStream() throws IOException {
        if (this.isClosed() || this.isShutdown()) {
            throw new IOException("Socket closed.");
        }
        NIOOutputStream output = this.nioOutputStream;
        if (output != null) {
            return output.getOutputStream();
        }
        Callable<OutputStream> callable = new Callable<OutputStream>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public OutputStream call() throws Exception {
                InterestWritableByteChannel source = AbstractNBSocket.this.getBaseWriteChannel();
                InterestWritableByteChannel bottom = AbstractNBSocket.this.getBottomFromChain(source);
                if (bottom.hasBufferedOutput()) {
                    throw new IllegalStateException("still buffered output");
                }
                Object object = AbstractNBSocket.this.LOCK;
                synchronized (object) {
                    if (AbstractNBSocket.this.shutdown) {
                        throw new IOException("shut down");
                    }
                    AbstractNBSocket.this.nioOutputStream = new NIOOutputStream(AbstractNBSocket.this, source);
                    AbstractNBSocket.this.writer = AbstractNBSocket.this.getBottomFromChain(source);
                    return AbstractNBSocket.this.nioOutputStream.getOutputStream();
                }
            }
        };
        Future<OutputStream> future = NIODispatcher.instance().getScheduledExecutorService().submit(callable);
        try {
            return future.get();
        }
        catch (ExecutionException ee) {
            throw new IOException(ee.getCause());
        }
        catch (InterruptedException ie) {
            throw new IOException(ie.getCause());
        }
    }

    @Override
    public long getReadTimeout() {
        if (this.reader instanceof NIOInputStream) {
            return 0L;
        }
        try {
            return this.getSoTimeout();
        }
        catch (SocketException se) {
            return 0L;
        }
    }

    @Override
    public final void handleIOException(IOException iox) {
        if (LOG.isDebugEnabled()) {
            LOG.debug(this, iox);
        }
        this.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void shutdown() {
        Object object = this.LOCK;
        synchronized (object) {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Shutting down socket & streams for: " + this);
        }
        this.shutdownSocketAndChannels();
        this.shutdownObservers();
        NIODispatcher.instance().getScheduledExecutorService().execute(new Runnable(){

            @Override
            public void run() {
                if (AbstractNBSocket.this.nioOutputStream != null) {
                    AbstractNBSocket.this.nioOutputStream.shutdown();
                }
                AbstractNBSocket.this.nioOutputStream = null;
                AbstractNBSocket.this.reader = new NoOpReader();
                AbstractNBSocket.this.writer = new NoOpWriter();
                AbstractNBSocket.this.throttleReader = null;
                AbstractNBSocket.this.connecter = null;
                AbstractNBSocket.this.shutdownObserver = null;
            }
        });
    }

    protected void shutdownObservers() {
        this.reader.shutdown();
        this.writer.shutdown();
        if (this.connecter != null) {
            this.connecter.shutdown();
        }
        if (this.shutdownObserver != null) {
            this.shutdownObserver.shutdown();
        }
    }

    private void shutdownSocketAndChannels() {
        this.shutdownImpl();
        try {
            this.getChannel().close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isShutdown() {
        Object object = this.LOCK;
        synchronized (object) {
            return this.shutdown;
        }
    }
}

