/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnsupportedAddressTypeException;
import org.limewire.nio.AbstractNBSocket;
import org.limewire.nio.NIODispatcher;
import org.limewire.nio.SocketInterestReadAdapter;
import org.limewire.nio.SocketInterestWriteAdapter;
import org.limewire.nio.channel.InterestReadableByteChannel;
import org.limewire.nio.channel.InterestWritableByteChannel;
import org.limewire.nio.observer.ConnectObserver;

public class NIOSocket
extends AbstractNBSocket {
    private final SocketChannel channel;
    private final Socket socket;
    private volatile SocketAddress remoteSocketAddress;

    protected NIOSocket(Socket s) {
        this.channel = s.getChannel();
        this.socket = this.channel.socket();
        this.remoteSocketAddress = s.getRemoteSocketAddress();
        this.initIncomingSocket();
        this.setInitialReader();
        this.setInitialWriter();
        NIODispatcher.instance().register(this.channel, this);
    }

    public NIOSocket() throws IOException {
        this.channel = SocketChannel.open();
        this.socket = this.channel.socket();
        this.initOutgoingSocket();
        this.setInitialReader();
        this.setInitialWriter();
    }

    public NIOSocket(InetAddress addr, int port) throws IOException {
        this.channel = SocketChannel.open();
        this.socket = this.channel.socket();
        this.initOutgoingSocket();
        this.setInitialReader();
        this.setInitialWriter();
        this.connect(new InetSocketAddress(addr, port));
    }

    public NIOSocket(InetAddress addr, int port, InetAddress localAddr, int localPort) throws IOException {
        this.channel = SocketChannel.open();
        this.socket = this.channel.socket();
        this.initOutgoingSocket();
        this.setInitialReader();
        this.setInitialWriter();
        this.bind(new InetSocketAddress(localAddr, localPort));
        this.connect(new InetSocketAddress(addr, port));
    }

    public NIOSocket(String addr, int port) throws UnknownHostException, IOException {
        this(InetAddress.getByName(addr), port);
    }

    public NIOSocket(String addr, int port, InetAddress localAddr, int localPort) throws IOException {
        this(InetAddress.getByName(addr), port, localAddr, localPort);
    }

    protected void initIncomingSocket() {
    }

    protected void initOutgoingSocket() throws IOException {
        this.channel.configureBlocking(false);
    }

    @Override
    public void bind(SocketAddress endpoint) throws IOException {
        this.socket.bind(endpoint);
    }

    @Override
    public boolean connect(SocketAddress addr, int timeout, ConnectObserver observer) {
        this.remoteSocketAddress = addr;
        return super.connect(addr, timeout, observer);
    }

    @Override
    public SocketAddress getRemoteSocketAddress() {
        return this.remoteSocketAddress;
    }

    @Override
    public InetAddress getInetAddress() {
        if (this.remoteSocketAddress != null) {
            return ((InetSocketAddress)this.remoteSocketAddress).getAddress();
        }
        return null;
    }

    @Override
    public int getPort() {
        if (this.remoteSocketAddress != null) {
            return ((InetSocketAddress)this.remoteSocketAddress).getPort();
        }
        return 0;
    }

    @Override
    protected InterestReadableByteChannel getBaseReadChannel() {
        return new SocketInterestReadAdapter(this.channel);
    }

    @Override
    protected InterestWritableByteChannel getBaseWriteChannel() {
        return new SocketInterestWriteAdapter(this.channel);
    }

    @Override
    protected void shutdownImpl() {
        try {
            this.shutdownInput();
        }
        catch (IOException ignored) {
            // empty catch block
        }
        try {
            this.shutdownOutput();
        }
        catch (IOException ignored) {
            // empty catch block
        }
        try {
            this.socket.close();
        }
        catch (IOException ignored) {
        }
        catch (Error error) {
            // empty catch block
        }
    }

    @Override
    public SocketChannel getChannel() {
        return this.channel;
    }

    @Override
    public int getLocalPort() {
        return this.socket.getLocalPort();
    }

    @Override
    public SocketAddress getLocalSocketAddress() {
        return this.socket.getLocalSocketAddress();
    }

    @Override
    public InetAddress getLocalAddress() {
        try {
            return this.socket.getLocalAddress();
        }
        catch (Error osxSucks) {
            try {
                return InetAddress.getLocalHost();
            }
            catch (UnknownHostException uhe) {
                return null;
            }
        }
        catch (UnsupportedAddressTypeException uate) {
            SocketAddress localAddr = this.socket.getLocalSocketAddress();
            throw new RuntimeException("wrong address type: " + (localAddr == null ? null : localAddr.getClass()), uate);
        }
    }

    @Override
    public boolean getOOBInline() throws SocketException {
        return this.socket.getOOBInline();
    }

    @Override
    public int getReceiveBufferSize() throws SocketException {
        return this.socket.getReceiveBufferSize();
    }

    @Override
    public boolean getReuseAddress() throws SocketException {
        return this.socket.getReuseAddress();
    }

    @Override
    public int getSendBufferSize() throws SocketException {
        return this.socket.getSendBufferSize();
    }

    @Override
    public int getSoLinger() throws SocketException {
        return this.socket.getSoLinger();
    }

    @Override
    public int getSoTimeout() throws SocketException {
        return this.socket.getSoTimeout();
    }

    @Override
    public boolean getTcpNoDelay() throws SocketException {
        return this.socket.getTcpNoDelay();
    }

    @Override
    public int getTrafficClass() throws SocketException {
        return this.socket.getTrafficClass();
    }

    @Override
    public boolean isBound() {
        return this.socket.isBound();
    }

    @Override
    public boolean isClosed() {
        return this.socket.isClosed();
    }

    @Override
    public boolean isConnected() {
        return this.socket.isConnected();
    }

    @Override
    public boolean isInputShutdown() {
        return this.socket.isInputShutdown();
    }

    @Override
    public boolean isOutputShutdown() {
        return this.socket.isOutputShutdown();
    }

    @Override
    public void sendUrgentData(int data) {
        throw new UnsupportedOperationException("No urgent data.");
    }

    @Override
    public void setKeepAlive(boolean on) throws SocketException {
        this.socket.setKeepAlive(on);
    }

    @Override
    public void setOOBInline(boolean on) throws SocketException {
        this.socket.setOOBInline(on);
    }

    @Override
    public void setReceiveBufferSize(int size) throws SocketException {
        this.socket.setReceiveBufferSize(size);
    }

    @Override
    public void setReuseAddress(boolean on) throws SocketException {
        this.socket.setReuseAddress(on);
    }

    @Override
    public void setSendBufferSize(int size) throws SocketException {
        this.socket.setSendBufferSize(size);
    }

    @Override
    public void setSoLinger(boolean on, int linger) throws SocketException {
        this.socket.setSoLinger(on, linger);
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        this.socket.setSoTimeout(timeout);
    }

    @Override
    public void setTcpNoDelay(boolean on) throws SocketException {
        this.socket.setTcpNoDelay(on);
    }

    @Override
    public void setTrafficClass(int tc) throws SocketException {
        this.socket.setTrafficClass(tc);
    }

    @Override
    public void shutdownInput() throws IOException {
        this.socket.shutdownInput();
    }

    @Override
    public void shutdownOutput() throws IOException {
        this.socket.shutdownOutput();
    }

    @Override
    public String toString() {
        return "NIOSocket::" + this.remoteSocketAddress + ", channel: " + this.channel.toString();
    }
}

