/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.nio.channel;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;
import org.limewire.nio.channel.ChannelReader;
import org.limewire.nio.channel.InterestReadableByteChannel;

public class InflaterReader
implements ChannelReader,
InterestReadableByteChannel {
    private Inflater inflater;
    private InterestReadableByteChannel channel;
    private ByteBuffer data;

    public InflaterReader(Inflater inflater) {
        this(null, inflater);
    }

    public InflaterReader(InterestReadableByteChannel channel, Inflater inflater) {
        if (inflater == null) {
            throw new NullPointerException("null inflater!");
        }
        this.channel = channel;
        this.inflater = inflater;
        this.data = ByteBuffer.allocate(512);
    }

    @Override
    public void setReadChannel(InterestReadableByteChannel channel) {
        if (channel == null) {
            throw new NullPointerException("cannot set null channel!");
        }
        this.channel = channel;
    }

    @Override
    public InterestReadableByteChannel getReadChannel() {
        return this.channel;
    }

    @Override
    public void interestRead(boolean status) {
        this.channel.interestRead(status);
    }

    @Override
    public int read(ByteBuffer buffer) throws IOException {
        int written = 0;
        int read = 0;
        while (buffer.hasRemaining()) {
            int inflated = this.inflate(buffer);
            written += inflated;
            if (inflated != 0) continue;
            if (this.inflater.finished() || this.inflater.needsDictionary()) {
                read = -1;
                break;
            }
            if (!this.inflater.needsInput()) continue;
            while (this.data.hasRemaining() && (read = this.channel.read(this.data)) > 0) {
            }
            if (this.data.position() == 0) break;
            this.inflater.setInput(this.data.array(), 0, this.data.position());
            this.data.clear();
        }
        if (written > 0) {
            return written;
        }
        if (read == -1) {
            return -1;
        }
        return 0;
    }

    private int inflate(ByteBuffer buffer) throws IOException {
        int written = 0;
        int position = buffer.position();
        try {
            written = this.inflater.inflate(buffer.array(), position, buffer.remaining());
        }
        catch (DataFormatException dfe) {
            IOException x = new IOException();
            x.initCause(dfe);
            throw x;
        }
        catch (NullPointerException npe) {
            IOException x = new IOException();
            x.initCause(npe);
            throw x;
        }
        buffer.position(position + written);
        return written;
    }

    @Override
    public boolean isOpen() {
        return this.channel.isOpen();
    }

    @Override
    public void close() throws IOException {
        this.channel.close();
    }
}

