/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.rudp;

import org.limewire.nio.observer.TransportListener;
import org.limewire.rudp.DefaultMessageDispatcher;
import org.limewire.rudp.DefaultRUDPSettings;
import org.limewire.rudp.DefaultUDPService;
import org.limewire.rudp.MessageDispatcher;
import org.limewire.rudp.RUDPContext;
import org.limewire.rudp.RUDPSettings;
import org.limewire.rudp.UDPService;
import org.limewire.rudp.messages.RUDPMessageFactory;
import org.limewire.rudp.messages.impl.DefaultMessageFactory;

public class DefaultRUDPContext
implements RUDPContext {
    private final RUDPMessageFactory messageFactory;
    private final TransportListener transportListener;
    private final UDPService udpService;
    private final MessageDispatcher messageDispatcher;
    private final RUDPSettings rudpSettings;

    public DefaultRUDPContext() {
        this(new DefaultMessageFactory(), new NoOpTransportListener(), null, new DefaultMessageDispatcher(), new DefaultRUDPSettings());
    }

    public DefaultRUDPContext(RUDPMessageFactory factory) {
        this(factory, new NoOpTransportListener(), null, new DefaultMessageDispatcher(), new DefaultRUDPSettings());
    }

    public DefaultRUDPContext(TransportListener transportListener) {
        this(new DefaultMessageFactory(), transportListener, null, new DefaultMessageDispatcher(), new DefaultRUDPSettings());
    }

    public DefaultRUDPContext(UDPService udpService) {
        this(new DefaultMessageFactory(), new NoOpTransportListener(), udpService, null, new DefaultRUDPSettings());
    }

    public DefaultRUDPContext(RUDPSettings settings) {
        this(new DefaultMessageFactory(), new NoOpTransportListener(), null, new DefaultMessageDispatcher(), settings);
    }

    public DefaultRUDPContext(RUDPMessageFactory factory, TransportListener transportListener, UDPService udpService, RUDPSettings settings) {
        this(factory, transportListener, udpService, null, settings);
    }

    public DefaultRUDPContext(RUDPMessageFactory factory, TransportListener transportListener, UDPService udpService, MessageDispatcher dispatcher, RUDPSettings settings) {
        this.messageFactory = factory;
        this.transportListener = transportListener;
        this.udpService = udpService == null ? new DefaultUDPService(dispatcher) : udpService;
        this.messageDispatcher = dispatcher;
        this.rudpSettings = settings;
    }

    @Override
    public RUDPMessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    @Override
    public TransportListener getTransportListener() {
        return this.transportListener;
    }

    @Override
    public UDPService getUDPService() {
        return this.udpService;
    }

    public MessageDispatcher getMessageDispatcher() {
        return this.messageDispatcher;
    }

    @Override
    public RUDPSettings getRUDPSettings() {
        return this.rudpSettings;
    }

    private static final class NoOpTransportListener
    implements TransportListener {
        private NoOpTransportListener() {
        }

        @Override
        public void eventPending() {
        }
    }
}

