/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.rudp;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.limewire.rudp.DataWindow;

public class WriteRegulator {
    private static final Log LOG = LogFactory.getLog(WriteRegulator.class);
    private static final int MIN_START_WINDOW = 40;
    private static final int LOW_WINDOW_SPACE = 4;
    private static final int MAX_SKIP_LIMIT = 14;
    private static final float LOW_FAILURE_RATE = 0.03f;
    private static final float HIGH_FAILURE_RATE = 0.04f;
    private DataWindow _sendWindow;
    private int _skipCount = 0;
    private int _skipLimit = 2;
    private boolean _limitHit = false;
    private int _limitCount = 0;
    private int _limitReset = 200;
    private int _zeroCount = 0;
    private FailureTracker _tracker;

    public WriteRegulator(DataWindow sendWindow) {
        this._sendWindow = sendWindow;
        this._tracker = new FailureTracker();
    }

    public void hitResendTimeout() {
        if ((!this._limitHit || this._limitCount >= 10) && this._tracker.failureRate() > 0.04f) {
            this._limitHit = true;
            this._skipLimit /= 2;
            this._limitCount = 0;
            if (LOG.isDebugEnabled()) {
                LOG.debug("hitResendTimeout _skipLimit = " + this._skipLimit + " fR=" + this._tracker.failureRateAsString());
            }
            this._tracker.clearOldFailures();
        }
    }

    public void hitZeroWindow() {
        ++this._zeroCount;
        if (!(this._limitHit && this._limitCount < 10 || this._zeroCount <= 4)) {
            this._zeroCount = 0;
            if (LOG.isDebugEnabled()) {
                LOG.debug("hitZeroWindow _skipLimit = " + this._skipLimit + " fR=" + this._tracker.failureRateAsString());
            }
        }
    }

    public long getSleepTime(long currTime, int receiverWindowSpace) {
        int isrtt;
        int usedSpots = this._sendWindow.getUsedSpots();
        int windowSize = this._sendWindow.getWindowSize();
        long windowStart = this._sendWindow.getWindowStart();
        int rto = this._sendWindow.getRTO();
        float rttvar = this._sendWindow.getRTTVar();
        float srtt = this._sendWindow.getSRTT();
        int realRTT = isrtt = (int)srtt;
        int lowRTT = this._sendWindow.lowRoundTripTime();
        int smoothRTT = isrtt;
        int sentWait = isrtt;
        int rtt = sentWait + 1;
        if (rtt == 0) {
            rtt = 10;
        }
        int baseWait = Math.min(realRTT, 2000) / 4;
        int sleepTime = (usedSpots + 1) * baseWait;
        int minTime = 0;
        int gettingSlow = 0;
        if (sleepTime < windowSize) {
            double pct = (double)sleepTime / (double)windowSize;
            sleepTime = Math.random() < pct ? 1 : 0;
        } else {
            sleepTime /= windowSize;
        }
        if (receiverWindowSpace <= 4) {
            int multiple = 4 / Math.max(1, receiverWindowSpace);
            sleepTime = (int)srtt * multiple / 5;
            if (receiverWindowSpace <= 2) {
                sleepTime = rto;
                if (LOG.isDebugEnabled()) {
                    LOG.debug("LOW_WINDOW sT:" + sleepTime);
                }
            }
            minTime = sleepTime;
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("sleepTime:" + sleepTime + " uS:" + usedSpots + " RWS:" + receiverWindowSpace + " smoothRTT:" + smoothRTT + " realRTT:" + realRTT + " rtt:" + rtt + " RTO:" + rto + " RTTVar:" + rttvar + " srtt:" + srtt + " sL:" + this._skipLimit + " fR=" + this._tracker.failureRateAsString());
        }
        if (this._skipLimit < 1) {
            this._skipLimit = 1;
        }
        int maxRTT = smoothRTT > 5 * lowRTT / 2 ? lowRTT * 7 / 5 : lowRTT * 25 / 5;
        int windowDelay = baseWait * windowSize / this._skipLimit * 2 / 4;
        if (rtt != 0 && baseWait != 0 && receiverWindowSpace <= 4 && (windowDelay < rtt || rtt > maxRTT)) {
            if (LOG.isDebugEnabled()) {
                LOG.debug(" -- MAX EXCEED  RTT sL:" + this._skipLimit + " w:" + windowStart + " Rrtt:" + realRTT + " base :" + baseWait + " uS:" + usedSpots + " RWS:" + receiverWindowSpace + " lRTT:" + this._sendWindow.lowRoundTripTime() + " sWait:" + sentWait + " mRTT:" + maxRTT + " wDelay:" + windowDelay + " sT:" + sleepTime);
            }
            if (rtt > maxRTT || realRTT > maxRTT) {
                minTime = lowRTT / 4;
                if (gettingSlow == 0) {
                    --this._skipLimit;
                }
                gettingSlow = 50;
                if (LOG.isDebugEnabled()) {
                    LOG.debug(" -- UP SLEEP  rtt:" + rtt + " mRTT:" + maxRTT + " rRTT:" + realRTT + " lRTT:" + lowRTT + " sT:" + sleepTime);
                }
            }
        }
        if (this._skipLimit < 1) {
            this._skipLimit = 1;
        }
        this._skipCount = (this._skipCount + 1) % this._skipLimit;
        if (!this._limitHit) {
            if (this._skipLimit < 14 && windowStart % (long)windowSize == 0L && gettingSlow == 0 && windowStart > 40L && this._tracker.failureRate() < 0.03f) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("up _skipLimit = " + this._skipLimit);
                }
                ++this._skipLimit;
                if (LOG.isDebugEnabled()) {
                    LOG.debug(" -- UPP sL:" + this._skipLimit);
                }
            }
        } else {
            ++this._limitCount;
            if (this._limitCount >= this._limitReset) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug(" -- UPP reset:" + this._skipLimit);
                }
                this._limitCount = 0;
                this._limitHit = false;
            }
        }
        if (this._skipCount != 0 && rtt < maxRTT && receiverWindowSpace > 4) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("_skipLimit = " + this._skipLimit);
            }
            sleepTime = 0;
        }
        sleepTime = Math.max(sleepTime, minTime);
        if (gettingSlow > 0) {
            --gettingSlow;
        }
        return sleepTime;
    }

    public void addMessageSuccess() {
        this._tracker.addSuccess();
    }

    public void addMessageFailure() {
        this._tracker.addFailure();
    }

    private static class FailureTracker {
        private static final int HISTORY_SIZE = 100;
        private final byte[] _data = new byte[100];
        private boolean _rollover = false;
        private int _index;

        private FailureTracker() {
        }

        public void addSuccess() {
            this._data[this._index++] = 1;
            if (this._index >= 99) {
                LOG.debug("rolled over");
                this._index = 0;
                this._rollover = true;
            }
        }

        public void addFailure() {
            this._data[this._index++] = 0;
            if (this._index >= 99) {
                LOG.debug("rolled over");
                this._index = 0;
                this._rollover = true;
            }
        }

        public void clearOldFailures() {
            for (int i = 0; i < 50; ++i) {
                this.addSuccess();
            }
        }

        public float failureRate() {
            int total = 0;
            for (int i = 0; i < (this._rollover ? 100 : this._index); ++i) {
                total += this._data[i];
            }
            if (LOG.isDebugEnabled()) {
                LOG.debug("failure rate from " + this._index + " measurements and rollover " + this._rollover + " total is " + total + " and rate " + (1.0f - (float)total / (float)(this._rollover ? 100 : this._index)));
            }
            return 1.0f - (float)total / (float)(this._rollover ? 100 : this._index);
        }

        public String failureRateAsString() {
            float rate = this.failureRate() * 1000.0f;
            int irate = (int)rate / 10;
            int drate = (int)rate - irate * 10;
            return "" + irate + "." + drate;
        }
    }
}

