/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.security;

import com.google.inject.Singleton;
import java.io.File;
import java.security.PublicKey;
import java.util.concurrent.ExecutorService;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.security.SecureMessage;
import org.limewire.security.SecureMessageCallback;
import org.limewire.security.SecureMessageVerifier;
import org.limewire.security.SignatureVerifier;
import org.limewire.security.Verifier;

@Singleton
public class SecureMessageVerifierImpl
implements SecureMessageVerifier {
    private final ExecutorService QUEUE;
    private PublicKey pubKey;
    private final File keyFile;
    private final String keyBase32;

    public SecureMessageVerifierImpl() {
        this(null, null, null, null);
    }

    public SecureMessageVerifierImpl(String name) {
        this(null, null, null, name);
    }

    public SecureMessageVerifierImpl(File keyFile) {
        this(keyFile, null, null, null);
    }

    public SecureMessageVerifierImpl(String keyBase32, String name) {
        this(null, keyBase32, null, name);
    }

    public SecureMessageVerifierImpl(File keyFile, String name) {
        this(keyFile, null, null, name);
    }

    public SecureMessageVerifierImpl(PublicKey pubKey, String name) {
        this(null, null, pubKey, name);
    }

    private SecureMessageVerifierImpl(File keyFile, String keyBase32, PublicKey pubKey, String name) {
        this.QUEUE = name == null ? ExecutorsHelper.newProcessingQueue("SecureMessageVerifier") : ExecutorsHelper.newProcessingQueue(name + "-SecureMessageVerifier");
        if (pubKey == null && keyFile == null == (keyBase32 == null)) {
            throw new IllegalArgumentException("must have only one source of key");
        }
        this.pubKey = pubKey;
        this.keyFile = keyFile;
        this.keyBase32 = keyBase32;
    }

    @Override
    public void verify(SecureMessage sm, SecureMessageCallback smc) {
        this.QUEUE.execute(new VerifierImpl(this.pubKey, "SHA1withDSA", sm, smc));
    }

    @Override
    public void verify(PublicKey pubKey, String algorithm, SecureMessage sm, SecureMessageCallback smc) {
        if (pubKey == null) {
            throw new IllegalArgumentException("PublicKey is null");
        }
        this.QUEUE.execute(new VerifierImpl(pubKey, algorithm, sm, smc));
    }

    @Override
    public void verify(Verifier verifier) {
        this.QUEUE.execute(verifier);
    }

    private void initializePublicKey() {
        if (this.pubKey == null) {
            this.pubKey = this.createPublicKey();
        }
    }

    protected PublicKey createPublicKey() {
        if (this.getKeyFile() == null && this.keyBase32 == null) {
            throw new NullPointerException("no key source!!");
        }
        if (this.keyBase32 != null) {
            return SignatureVerifier.readKey(this.keyBase32, "DSA");
        }
        return SignatureVerifier.readKey(this.getKeyFile(), "DSA");
    }

    protected File getKeyFile() {
        return this.keyFile;
    }

    private class VerifierImpl
    extends Verifier {
        private PublicKey pubKey;
        private String algorithm;

        VerifierImpl(PublicKey pubKey, String algorithm, SecureMessage message, SecureMessageCallback callback) {
            super(message, callback);
            this.pubKey = pubKey;
            this.algorithm = algorithm;
        }

        @Override
        public String getAlgorithm() {
            return this.algorithm;
        }

        @Override
        public PublicKey getPublicKey() {
            if (this.pubKey == null) {
                SecureMessageVerifierImpl.this.initializePublicKey();
                this.pubKey = SecureMessageVerifierImpl.this.pubKey;
            }
            return this.pubKey;
        }
    }
}

