/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.setting;

import java.util.Properties;
import org.limewire.setting.LongSetting;

public final class PowerOfTwoSetting
extends LongSetting {
    PowerOfTwoSetting(Properties defaultProps, Properties props, String key, long defaultLong) {
        super(defaultProps, props, key, defaultLong);
        if (!PowerOfTwoSetting.isPowerOfTwo(defaultLong)) {
            throw new IllegalArgumentException("Default value is not a power of two");
        }
    }

    PowerOfTwoSetting(Properties defaultProps, Properties props, String key, long defaultLong, long min, long max) {
        super(defaultProps, props, key, defaultLong, min, max);
        if (!PowerOfTwoSetting.isPowerOfTwo(defaultLong)) {
            throw new IllegalArgumentException("Default value is not a power of two");
        }
        if (!PowerOfTwoSetting.isPowerOfTwo(max)) {
            throw new IllegalArgumentException("Max value is not a power of two");
        }
        if (!PowerOfTwoSetting.isPowerOfTwo(min)) {
            throw new IllegalArgumentException("Min value is not a power of two");
        }
    }

    private static boolean isPowerOfTwo(long x) {
        if (x <= 0L) {
            return false;
        }
        return ((x ^ 0xFFFFFFFFFFFFFFFFL) + 1L & x) == x;
    }

    @Override
    protected String normalizeValue(String value) {
        long longValue;
        try {
            longValue = Long.parseLong(value);
        }
        catch (NumberFormatException e) {
            return this.DEFAULT_VALUE;
        }
        if (longValue <= 0L) {
            if (this.MIN_VALUE != null) {
                return ((Long)this.MIN_VALUE).toString();
            }
            return super.normalizeValue("1");
        }
        long lowestSetBit = (longValue ^ 0xFFFFFFFFFFFFFFFFL) + 1L & longValue;
        if (lowestSetBit != longValue) {
            while ((lowestSetBit = ((longValue -= lowestSetBit) ^ 0xFFFFFFFFFFFFFFFFL) + 1L & longValue) != longValue) {
            }
            if (longValue == 0L) {
                longValue = 1L;
            }
            value = String.valueOf(longValue);
        }
        return super.normalizeValue(value);
    }
}

