/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.swarm.http;

import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.URI;
import org.limewire.collection.IntervalSet;
import org.limewire.collection.Range;
import org.limewire.swarm.SwarmSourceType;
import org.limewire.swarm.impl.AbstractSwarmSource;
import org.limewire.swarm.impl.LoggingSwarmSourceListener;
import org.limewire.swarm.impl.ReconnectingSwarmSourceListener;
import org.limewire.util.URIUtils;

public class SwarmHttpSource
extends AbstractSwarmSource {
    private final SocketAddress socketAddress;
    private final String path;
    private IntervalSet availableRanges = new IntervalSet();
    private final String id;

    public SwarmHttpSource(URI uri, Range range) {
        int port = URIUtils.getPort(uri) == -1 ? 80 : URIUtils.getPort(uri);
        String host = uri.getHost();
        this.socketAddress = new InetSocketAddress(host, port);
        this.path = uri.getPath();
        this.availableRanges.add(range);
        this.addListener(new ReconnectingSwarmSourceListener());
        this.addListener(new LoggingSwarmSourceListener());
        this.id = uri.toString() + "-" + range.toString();
    }

    public SwarmHttpSource(URI uri, long fileSize) {
        this(uri, Range.createRange(0L, fileSize - 1L));
    }

    @Override
    public SocketAddress getAddress() {
        return this.socketAddress;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    public String toString() {
        return "Source for: " + this.socketAddress + ", uri: " + this.path + ", id: " + System.identityHashCode(this);
    }

    @Override
    public IntervalSet getAvailableRanges() {
        return this.availableRanges;
    }

    @Override
    public SwarmSourceType getType() {
        return SwarmSourceType.HTTP;
    }

    @Override
    public boolean equals(Object obj) {
        if (!(obj instanceof SwarmHttpSource)) {
            return false;
        }
        SwarmHttpSource source = (SwarmHttpSource)obj;
        if (this.getType() != source.getType()) {
            return false;
        }
        return this.id.equals(source.id);
    }

    @Override
    public int hashCode() {
        return this.id.hashCode();
    }

    public static boolean isValidSource(URI uri) {
        return uri.getHost() != null && ("http".equals(uri.getScheme()) || uri.getScheme() == null);
    }
}

