/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.swarm.impl;

import org.limewire.logging.Log;
import org.limewire.logging.LogFactory;
import org.limewire.swarm.SwarmSource;
import org.limewire.swarm.SwarmSourceDownloader;
import org.limewire.swarm.SwarmSourceListener;
import org.limewire.swarm.SwarmStatus;
import org.limewire.swarm.impl.FinishedSwarmStatus;

public class ReconnectingSwarmSourceListener
implements SwarmSourceListener {
    private static final Log LOG = LogFactory.getLog(ReconnectingSwarmSourceListener.class);
    private SwarmStatus connectionStatus = null;

    @Override
    public void connected(SwarmSourceDownloader swarmSourceHandler, SwarmSource source) {
        LOG.tracef("connected: {0}", (Object)source);
    }

    @Override
    public void connectFailed(SwarmSourceDownloader swarmSourceHandler, SwarmSource source) {
        LOG.tracef("connectFailed: {0}", (Object)source);
    }

    @Override
    public void connectionClosed(SwarmSourceDownloader swarmSourceHandler, SwarmSource source) {
        this.connectionClosed(swarmSourceHandler, source, this.connectionStatus);
    }

    private void connectionClosed(SwarmSourceDownloader swarmSourceHandler, SwarmSource source, SwarmStatus status) {
        if (status != null && status.isFinished() || swarmSourceHandler.isComplete() || source.isFinished()) {
            LOG.tracef("finished, not reconnecting: {0} status: {1}", (Object)source, (Object)status);
        } else if (status != null && status.isError()) {
            LOG.tracef("error, not reconnecting: {0} status: {1}", (Object)source, (Object)status);
        } else if (status == null || status.isOk()) {
            LOG.tracef("reconnecting: {0} status: {1}", (Object)source, (Object)status);
            swarmSourceHandler.addSource(source);
        } else {
            LOG.tracef("connectionClosed: {0} status: {1}", (Object)source, (Object)status);
        }
    }

    @Override
    public void responseProcessed(SwarmSourceDownloader swarmSourceHandler, SwarmSource source, SwarmStatus status) {
        this.connectionStatus = status;
        LOG.tracef("responseProcessed: {0} status: {1}", (Object)source, (Object)status);
    }

    @Override
    public void finished(SwarmSourceDownloader swarmSourceHandler, SwarmSource source) {
        this.connectionStatus = new FinishedSwarmStatus();
        LOG.tracef("finished: {0}", (Object)source);
    }
}

