/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.mojito.visual;

import com.google.inject.Inject;
import com.limegroup.gnutella.dht.DHTManager;
import javax.swing.JComponent;
import org.limewire.mojito.Context;
import org.limewire.mojito.visual.ArcsVisualizer;
import org.limewire.ui.swing.plugin.SwingUiPlugin;

class ArcsPlugin
implements SwingUiPlugin {
    private final DHTManager dhtManager;
    private volatile ArcsVisualizer arcsVisualizer;

    @Inject
    public ArcsPlugin(DHTManager dhtManager) {
        this.dhtManager = dhtManager;
    }

    @Override
    public JComponent getPluginComponent() {
        Context context;
        if (this.arcsVisualizer != null) {
            this.arcsVisualizer.stopArcs();
            this.arcsVisualizer = null;
        }
        if ((context = (Context)this.dhtManager.getMojitoDHT()) == null) {
            return null;
        }
        this.arcsVisualizer = new ArcsVisualizer(context, context.getLocalNodeID());
        return this.arcsVisualizer;
    }

    @Override
    public void startPlugin() {
        if (this.arcsVisualizer != null) {
            this.arcsVisualizer.startArcs();
        }
    }

    @Override
    public void stopPlugin() {
        if (this.arcsVisualizer != null) {
            this.arcsVisualizer.stopArcs();
        }
    }

    @Override
    public String getPluginName() {
        return "Mojito Arcs Visualizer";
    }
}

