/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing;

import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Rectangle;
import java.awt.Window;

public class AWTSplashWindow
extends Window {
    private Image splashImage;
    private volatile boolean paintCalled = false;

    public AWTSplashWindow(Frame owner, Image splashImage, Rectangle bounds) {
        super(owner);
        this.splashImage = splashImage;
        MediaTracker mt2 = new MediaTracker(this);
        mt2.addImage(splashImage, 0);
        try {
            mt2.waitForID(0);
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
        if (mt2.isErrorAny()) {
            this.paintCalled = true;
        }
        if (bounds != null) {
            this.setBounds(bounds);
        } else {
            int imgHeight;
            int imgWidth = splashImage.getWidth(this);
            if (imgWidth < 1) {
                imgWidth = 1;
            }
            if ((imgHeight = splashImage.getHeight(this)) < 1) {
                imgHeight = 1;
            }
            this.setSize(imgWidth, imgHeight);
            this.setLocationRelativeTo(null);
        }
    }

    @Override
    public void update(Graphics g) {
        g.setColor(this.getForeground());
        this.paint(g);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g) {
        g.drawImage(this.splashImage, 0, 0, this);
        if (!this.paintCalled) {
            this.paintCalled = true;
            AWTSplashWindow aWTSplashWindow = this;
            synchronized (aWTSplashWindow) {
                this.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Frame splash(Image splashImage, Rectangle bounds) {
        Frame f = new Frame();
        AWTSplashWindow w = new AWTSplashWindow(f, splashImage, bounds);
        w.toFront();
        w.setVisible(true);
        if (!EventQueue.isDispatchThread()) {
            AWTSplashWindow aWTSplashWindow = w;
            synchronized (aWTSplashWindow) {
                while (!w.paintCalled) {
                    try {
                        w.wait();
                    }
                    catch (InterruptedException e) {}
                }
            }
        }
        return f;
    }
}

