/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing;

import java.awt.IllegalComponentStateException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.limewire.service.ErrorService;

public class DefaultErrorCatcher {
    private static volatile boolean storeCaughtBugs = false;
    private static final List<Throwable> storedBugs = new CopyOnWriteArrayList<Throwable>();

    static void install() {
        System.setProperty("sun.awt.exception.handler", DefaultErrorCatcher.class.getName());
    }

    static void storeCaughtBugs() {
        storeCaughtBugs = true;
    }

    static List<Throwable> getAndResetStoredBugs() {
        storeCaughtBugs = false;
        ArrayList<Throwable> list = new ArrayList<Throwable>(storedBugs);
        storedBugs.clear();
        return list;
    }

    public void handle(Throwable ex) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        ex.printStackTrace(pw);
        pw.flush();
        String bug = sw.toString();
        if (!this.isIgnorable(ex, bug)) {
            if (storeCaughtBugs) {
                storedBugs.add(ex);
            } else {
                ErrorService.error(ex, "Uncaught event-thread error.");
            }
        } else {
            System.err.println("Ignoring error:");
            ex.printStackTrace();
        }
    }

    private boolean isIgnorable(Throwable bug, String msg) {
        if (bug instanceof StackOverflowError) {
            return true;
        }
        if (msg == null) {
            return true;
        }
        if (msg.indexOf("javax.swing.RepaintManager") != -1) {
            return true;
        }
        if (msg.indexOf("sun.awt.RepaintArea.paint") != -1) {
            return true;
        }
        if (bug instanceof ArrayIndexOutOfBoundsException) {
            if (msg.indexOf("apple.awt.CWindow.displayChanged") != -1) {
                return true;
            }
            if (msg.indexOf("javax.swing.plaf.basic.BasicTabbedPaneUI.getTabBounds") != -1) {
                return true;
            }
        }
        if (bug instanceof IllegalStateException && msg.indexOf("cannot open system clipboard") != -1) {
            return true;
        }
        if (bug instanceof IllegalComponentStateException && msg.indexOf("component must be showing on the screen to determine its location") != -1) {
            return true;
        }
        if (bug instanceof NullPointerException) {
            if (msg.indexOf("MetalFileChooserUI") != -1) {
                return true;
            }
            if (msg.indexOf("WindowsFileChooserUI") != -1) {
                return true;
            }
            if (msg.indexOf("AquaDirectoryModel") != -1) {
                return true;
            }
            if (msg.indexOf("SizeRequirements.calculateAlignedPositions") != -1) {
                return true;
            }
            if (msg.indexOf("BasicTextUI.damageRange") != -1) {
                return true;
            }
            if (msg.indexOf("null pData") != -1) {
                return true;
            }
            if (msg.indexOf("disposed component") != -1) {
                return true;
            }
        }
        if (bug instanceof InternalError && msg.indexOf("getGraphics not implemented for this component") != -1) {
            return true;
        }
        if (msg.indexOf("com.limegroup.gnutella") == -1 && msg.indexOf("org.limewire") == -1) {
            return true;
        }
        StackTraceElement[] stack = bug.getStackTrace();
        if (stack != null) {
            if (bug instanceof IndexOutOfBoundsException && stack.length > 2 && stack[0].getClassName().equals("javax.swing.DefaultRowSorter") && stack[1].getClassName().equals("sun.swing.FilePane$SortableListModel")) {
                return true;
            }
            if (bug instanceof NullPointerException && stack.length > 2 && stack[0].getClassName().equals("javax.swing.JComponent") && stack[1].getClassName().equals("sun.swing.FilePane$2")) {
                return true;
            }
        }
        return false;
    }
}

