/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.browser;

import java.util.Locale;
import org.limewire.util.Objects;

public interface UriAction {
    public boolean uriClicked(TargetedUri var1);

    public static class TargetedUri {
        private final String target;
        private final String url;
        private final String protocol;

        public TargetedUri(String target, String uri) {
            this.target = Objects.nonNull(target, "target");
            this.url = uri;
            this.protocol = TargetedUri.extractProtocol(uri);
        }

        private static String extractProtocol(String url) {
            int colon = url.indexOf(58);
            if (colon != -1) {
                String protocol = url.substring(0, colon);
                return protocol.toLowerCase(Locale.US);
            }
            return null;
        }

        public String getTarget() {
            return this.target;
        }

        public String getUri() {
            return this.url;
        }

        public String getProtocol() {
            return this.protocol;
        }
    }
}

