/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.components;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.util.Collection;
import java.util.Collections;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.ListModel;
import javax.swing.UIManager;
import net.miginfocom.swing.MigLayout;
import org.limewire.collection.AutoCompleteDictionary;
import org.limewire.collection.NECallable;
import org.limewire.collection.StringTrieSet;
import org.limewire.concurrent.ExecutorsHelper;
import org.limewire.concurrent.ListeningExecutorService;
import org.limewire.concurrent.ListeningFuture;
import org.limewire.concurrent.SimpleFuture;
import org.limewire.ui.swing.components.AutoCompleter;
import org.limewire.ui.swing.components.CollectionBackedListModel;
import org.limewire.ui.swing.util.SwingUtils;

public class BasicAutoCompleter
implements AutoCompleter {
    private final ListeningExecutorService queue = ExecutorsHelper.newProcessingQueue("AutoCompleteQueue");
    private final JPanel entryPanel;
    private final AutoCompleteList entryList;
    private ListeningFuture<Boolean> lastFuture;
    private AutoCompleter.AutoCompleterCallback callback;
    private String currentText;
    private AutoCompleteDictionary dictionary;

    public BasicAutoCompleter() {
        this(new StringTrieSet(true));
    }

    public BasicAutoCompleter(AutoCompleteDictionary dictionary) {
        this.dictionary = dictionary;
        this.entryPanel = new JPanel(new MigLayout("insets 0, gap 0, fill"));
        this.entryPanel.setBorder(UIManager.getBorder("List.border"));
        this.entryPanel.setBackground(UIManager.getColor("List.background"));
        this.entryList = new AutoCompleteList();
        JScrollPane entryScrollPane = new JScrollPane(this.entryList);
        entryScrollPane.setVerticalScrollBarPolicy(20);
        entryScrollPane.setHorizontalScrollBarPolicy(31);
        this.entryPanel.add((Component)entryScrollPane, "grow");
    }

    public void setDictionary(AutoCompleteDictionary dictionary) {
        this.dictionary = dictionary;
    }

    public void addAutoCompleteSuggestion(String text) {
        this.dictionary.addEntry(text);
    }

    @Override
    public void setAutoCompleterCallback(AutoCompleter.AutoCompleterCallback callback) {
        this.callback = callback;
    }

    @Override
    public boolean isAutoCompleteAvailable() {
        return this.entryList.getModel().getSize() != 0;
    }

    @Override
    public void decrementSelection() {
        this.entryList.decrementSelection();
    }

    @Override
    public JComponent getRenderComponent() {
        return this.entryPanel;
    }

    @Override
    public String getSelectedAutoCompleteString() {
        return (String)this.entryList.getSelectedValue();
    }

    @Override
    public void incrementSelection() {
        this.entryList.incrementSelection();
    }

    @Override
    public ListeningFuture<Boolean> setInput(String input) {
        if (input == null) {
            input = "";
        }
        this.currentText = input;
        NECallable<Boolean> runner = new NECallable<Boolean>(){

            @Override
            public Boolean call() {
                try {
                    final Collection<String> suggestions = BasicAutoCompleter.this.dictionary.getPrefixedBy(BasicAutoCompleter.this.currentText);
                    SwingUtils.invokeNowOrWaitWithInterrupted(new Runnable(){

                        @Override
                        public void run() {
                            BasicAutoCompleter.this.setSuggestions(suggestions);
                        }
                    });
                    return true;
                }
                catch (InterruptedException ignored) {
                    return false;
                }
            }
        };
        if (this.dictionary.isImmediate()) {
            runner.call();
            return new SimpleFuture<Boolean>(true);
        }
        if (this.lastFuture != null) {
            this.lastFuture.cancel(true);
        }
        this.setSuggestions(Collections.<String>emptyList());
        this.lastFuture = this.queue.submit(runner);
        return this.lastFuture;
    }

    private void setSuggestions(Collection<String> suggestions) {
        boolean different;
        ListModel model = this.entryList.getModel();
        boolean bl = different = suggestions.size() != model.getSize();
        if (!different) {
            int i = 0;
            for (String item : suggestions) {
                if (i < model.getSize() && item.equals(model.getElementAt(i))) {
                    different = true;
                    break;
                }
                ++i;
            }
        }
        if (different) {
            this.entryList.setModel(new CollectionBackedListModel(suggestions));
            this.entryList.setVisibleRowCount(Math.min(8, suggestions.size()));
            this.entryList.clearSelection();
        }
    }

    private class AutoCompleteList
    extends JList {
        AutoCompleteList() {
            this.enableEvents(16L);
            this.setSelectionMode(0);
            this.setFocusable(false);
        }

        @Override
        protected void processMouseEvent(MouseEvent me) {
            int idx;
            super.processMouseEvent(me);
            if (me.getID() == 500 && (idx = this.locationToIndex(me.getPoint())) != -1 && this.isSelectedIndex(idx)) {
                BasicAutoCompleter.this.callback.itemSuggested((String)this.getSelectedValue(), false, true);
            }
        }

        void incrementSelection() {
            if (this.getSelectedIndex() == this.getModel().getSize() - 1) {
                BasicAutoCompleter.this.callback.itemSuggested(BasicAutoCompleter.this.currentText, true, false);
                this.clearSelection();
            } else {
                int selectedIndex = this.getSelectedIndex() + 1;
                this.setSelectedIndex(selectedIndex);
                this.ensureIndexIsVisible(selectedIndex);
                BasicAutoCompleter.this.callback.itemSuggested((String)this.getSelectedValue(), true, false);
            }
        }

        void decrementSelection() {
            if (this.getSelectedIndex() == 0) {
                BasicAutoCompleter.this.callback.itemSuggested(BasicAutoCompleter.this.currentText, true, false);
                this.clearSelection();
            } else {
                int selectedIndex = this.getSelectedIndex();
                selectedIndex = selectedIndex == -1 ? this.getModel().getSize() - 1 : --selectedIndex;
                this.setSelectedIndex(selectedIndex);
                this.ensureIndexIsVisible(selectedIndex);
                BasicAutoCompleter.this.callback.itemSuggested((String)this.getSelectedValue(), true, false);
            }
        }
    }
}

