/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.components;

import java.awt.Component;
import java.awt.Font;
import java.util.Locale;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JList;
import org.jdesktop.application.Resource;
import org.limewire.ui.swing.components.NonNullJComboBox;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.LanguageUtils;

public class LanguageComboBox
extends NonNullJComboBox {
    @Resource
    private Font font;

    public LanguageComboBox() {
        GuiUtils.assignResources(this);
        this.setRenderer(new LocaleRenderer());
        this.setFont(this.font);
        Locale[] locales = LanguageUtils.getLocales(this.font);
        if (locales.length == 0) {
            locales = new Locale[]{Locale.ENGLISH};
        }
        this.setModel(new DefaultComboBoxModel<Locale>(locales));
    }

    public static class LocaleRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
            super.getListCellRendererComponent((JList<?>)list, value, index, isSelected, hasFocus);
            if (value instanceof Locale) {
                Locale locale = (Locale)value;
                String language = locale.getDisplayName(locale);
                if (language.equals("Gallegan")) {
                    this.setText("galego");
                } else {
                    this.setText(language);
                }
            } else {
                this.setIcon(null);
            }
            return this;
        }
    }
}

