/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.components;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.text.NumberFormat;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import org.limewire.ui.swing.components.LimeProgressBar;
import org.limewire.ui.swing.components.decorators.ProgressBarDecorator;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.SwingUtils;

public class SplashWindow {
    private final NumberFormat numberFormat;
    private final JPanel textAndProgressPanel;
    private final JLabel textLabel;
    private final LimeProgressBar progressBar;
    private final JLabel splashLabel;
    private final JWindow splashWindow = new JWindow();

    public SplashWindow(Image splashImage, boolean isPro, Locale locale, int steps) {
        int imgHeight;
        this.splashLabel = new JLabel();
        this.textAndProgressPanel = new JPanel();
        this.numberFormat = NumberFormat.getInstance(locale);
        this.numberFormat.setMaximumIntegerDigits(3);
        this.numberFormat.setMaximumFractionDigits(0);
        this.textLabel = new JLabel();
        this.textLabel.setOpaque(false);
        this.textLabel.setFont(new Font("Dialog", 0, 12));
        this.textLabel.setForeground(Color.WHITE);
        this.progressBar = new LimeProgressBar();
        if (isPro) {
            ProgressBarDecorator.decorateStaticPro(this.progressBar);
        } else {
            ProgressBarDecorator.decorateStaticBasic(this.progressBar);
        }
        int width = this.progressBar.getPreferredSize().width;
        this.progressBar.setPreferredSize(new Dimension(width, 8));
        this.progressBar.setMinimumSize(new Dimension(width, 8));
        this.progressBar.setMaximumSize(new Dimension(Integer.MAX_VALUE, 8));
        this.progressBar.setMaximum(steps + 1);
        this.progressBar.setMinimum(0);
        this.progressBar.setValue(0);
        this.textAndProgressPanel.setLayout(new BoxLayout(this.textAndProgressPanel, 1));
        this.textAndProgressPanel.setOpaque(false);
        JPanel panel = new JPanel(new BorderLayout());
        panel.setOpaque(false);
        panel.add((Component)this.textLabel, "South");
        this.textAndProgressPanel.add(Box.createVerticalGlue());
        this.textAndProgressPanel.add(panel);
        this.textAndProgressPanel.add(Box.createVerticalStrut(2));
        this.textAndProgressPanel.add(this.progressBar);
        this.textAndProgressPanel.setBorder(BorderFactory.createEmptyBorder(0, 8, 8, 8));
        int imgWidth = splashImage.getWidth(null);
        if (imgWidth < 1) {
            imgWidth = 1;
        }
        if ((imgHeight = splashImage.getHeight(null)) < 1) {
            imgHeight = 1;
        }
        Dimension size = new Dimension(imgWidth + 2, imgHeight + 2);
        this.splashWindow.setSize(size);
        this.splashWindow.setLocationRelativeTo(null);
        this.splashLabel.setIcon(new ImageIcon(splashImage));
        this.splashWindow.getContentPane().add((Component)this.splashLabel, "Center");
        this.splashWindow.setGlassPane(this.textAndProgressPanel);
        this.splashWindow.pack();
    }

    public void begin() {
        SwingUtils.invokeNowOrLater(new Runnable(){

            @Override
            public void run() {
                SplashWindow.this.splashWindow.toFront();
                SplashWindow.this.splashWindow.setVisible(true);
                SplashWindow.this.textAndProgressPanel.setVisible(true);
                SplashWindow.this.setStatusText(I18n.tr("Loading LimeWire..."));
            }
        });
    }

    public void setStatusText(final String text) {
        SwingUtils.invokeNowOrLater(new Runnable(){

            @Override
            public void run() {
                SplashWindow.this.textLabel.setText(text);
                SplashWindow.this.progressBar.setValue(SplashWindow.this.progressBar.getValue() + 1);
                SplashWindow.this.textAndProgressPanel.paintImmediately(0, 0, SplashWindow.this.textAndProgressPanel.getWidth(), SplashWindow.this.textAndProgressPanel.getHeight());
            }
        });
    }

    public void dispose() {
        SwingUtils.invokeNowOrLater(new Runnable(){

            @Override
            public void run() {
                SplashWindow.this.splashWindow.dispose();
            }
        });
    }
}

