/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.downloads;

import com.google.inject.Inject;
import com.google.inject.Provider;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.table.TableCellEditor;
import org.jdesktop.application.Application;
import org.jdesktop.application.ApplicationActionMap;
import org.limewire.core.api.URN;
import org.limewire.core.api.download.DownloadItem;
import org.limewire.core.api.download.DownloadListManager;
import org.limewire.core.api.download.DownloadState;
import org.limewire.core.api.file.CategoryManager;
import org.limewire.inject.EagerSingleton;
import org.limewire.setting.evt.SettingEvent;
import org.limewire.setting.evt.SettingListener;
import org.limewire.ui.swing.downloads.DownloadItemUtils;
import org.limewire.ui.swing.downloads.DownloadMediator;
import org.limewire.ui.swing.downloads.table.AVInfoPanel;
import org.limewire.ui.swing.downloads.table.DownloadTable;
import org.limewire.ui.swing.downloads.table.DownloadTableFactory;
import org.limewire.ui.swing.settings.SwingUiSettings;
import org.limewire.ui.swing.tray.Notification;
import org.limewire.ui.swing.tray.TrayNotifier;
import org.limewire.ui.swing.util.GuiUtils;
import org.limewire.ui.swing.util.I18n;
import org.limewire.ui.swing.util.SwingUtils;

@EagerSingleton
public class MainDownloadPanel
extends JPanel {
    public static final String NAME = "MainDownloadPanel";
    private final DownloadMediator downloadMediator;
    private final Provider<DownloadTableFactory> downloadTableFactory;
    private final DownloadListManager downloadListManager;
    private final CategoryManager categoryManager;
    private final Provider<AVInfoPanel> avInfoPanelFactory;
    private TrayNotifier notifier;
    private boolean isInitialized = false;
    private DownloadTable table;

    @Inject
    public MainDownloadPanel(Provider<DownloadTableFactory> downloadTableFactory, DownloadMediator downloadMediator, TrayNotifier notifier, DownloadListManager downloadListManager, CategoryManager categoryManager, Provider<AVInfoPanel> avInfoPanelFactory) {
        this.downloadMediator = downloadMediator;
        this.downloadTableFactory = downloadTableFactory;
        this.downloadListManager = downloadListManager;
        this.categoryManager = categoryManager;
        this.avInfoPanelFactory = avInfoPanelFactory;
        this.notifier = notifier;
        GuiUtils.assignResources(this);
    }

    public void selectAndScrollTo(URN urn) {
        if (this.table == null) {
            this.initialize();
        }
        this.table.selectAndScrollTo(urn);
    }

    @Inject
    public void register() {
        SwingUiSettings.SHOW_TRANSFERS_TRAY.addSettingListener(new SettingListener(){

            @Override
            public void settingChanged(SettingEvent evt) {
                SwingUtils.invokeNowOrLater(new Runnable(){

                    @Override
                    public void run() {
                        MainDownloadPanel.this.initialize();
                    }
                });
            }
        });
        if (SwingUiSettings.SHOW_TRANSFERS_TRAY.getValue()) {
            this.initialize();
        }
        this.downloadListManager.addPropertyChangeListener(new DownloadPropertyListener());
    }

    private void initialize() {
        if (!this.isInitialized) {
            this.isInitialized = true;
            this.setLayout(new BorderLayout());
            this.table = this.downloadTableFactory.get().create(this.downloadMediator.getDownloadList());
            this.table.setTableHeader(null);
            JScrollPane pane = new JScrollPane(this.table);
            pane.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
            this.add((Component)pane, "Center");
        }
    }

    public List<DownloadItem> getSelectedDownloadItems() {
        return this.table.getSelectedItems();
    }

    private class DownloadPropertyListener
    implements PropertyChangeListener {
        private DownloadPropertyListener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent event) {
            if (event.getPropertyName().equals("downloadCompleted")) {
                TableCellEditor editor;
                final DownloadItem downloadItem = (DownloadItem)event.getNewValue();
                DownloadState state = downloadItem.getState();
                if (downloadItem.getDownloadItemType() != DownloadItem.DownloadItemType.ANTIVIRUS) {
                    if (state == DownloadState.THREAT_FOUND) {
                        ((AVInfoPanel)MainDownloadPanel.this.avInfoPanelFactory.get()).showThreatMessage(downloadItem, true);
                    } else if (state == DownloadState.SCAN_FAILED) {
                        ((AVInfoPanel)MainDownloadPanel.this.avInfoPanelFactory.get()).showFailureMessage(downloadItem, true);
                    } else if (state == DownloadState.SCAN_FAILED_DOWNLOADING_DEFINITIONS) {
                        ((AVInfoPanel)MainDownloadPanel.this.avInfoPanelFactory.get()).showFailureMessageDefsDownloading(downloadItem, true);
                    } else if (state == DownloadState.DANGEROUS) {
                        ((AVInfoPanel)MainDownloadPanel.this.avInfoPanelFactory.get()).showDangerMessage(downloadItem, true);
                    } else {
                        MainDownloadPanel.this.notifier.showMessage(new Notification(I18n.tr("Download Complete"), downloadItem.getFileName(), new AbstractAction(){

                            @Override
                            public void actionPerformed(ActionEvent e) {
                                ApplicationActionMap map = Application.getInstance().getContext().getActionManager().getActionMap();
                                map.get("restoreView").actionPerformed(e);
                                if (downloadItem.isLaunchable()) {
                                    DownloadItemUtils.launch(downloadItem, MainDownloadPanel.this.categoryManager);
                                }
                            }
                        }));
                    }
                }
                if (MainDownloadPanel.this.table == null) {
                    MainDownloadPanel.this.initialize();
                }
                if ((editor = MainDownloadPanel.this.table.getCellEditor()) != null) {
                    editor.cancelCellEditing();
                }
            }
        }
    }
}

