/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.filter;

import ca.odell.glazedlists.matchers.Matcher;
import ca.odell.glazedlists.matchers.MatcherEditor;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Icon;
import org.jdesktop.application.Resource;
import org.limewire.ui.swing.filter.Filter;
import org.limewire.ui.swing.filter.FilterInspectionUtils;
import org.limewire.ui.swing.filter.FilterListener;
import org.limewire.ui.swing.filter.FilterMatcherEditor;
import org.limewire.ui.swing.filter.FilterableItem;
import org.limewire.ui.swing.util.GuiUtils;

abstract class AbstractFilter<E extends FilterableItem>
implements Filter<E> {
    private final List<FilterListener<E>> listenerList = new ArrayList<FilterListener<E>>();
    private final FilterMatcherEditor<E> editor;
    private final FilterResources resources = new FilterResources();
    private boolean active;
    private String activeText;

    public AbstractFilter() {
        this.editor = new FilterMatcherEditor();
    }

    @Override
    public void addFilterListener(FilterListener<E> listener) {
        if (!this.listenerList.contains(listener)) {
            this.listenerList.add(listener);
        }
    }

    @Override
    public void removeFilterListener(FilterListener listener) {
        this.listenerList.remove(listener);
    }

    protected void fireFilterChanged(Filter<E> filter) {
        int size = this.listenerList.size();
        for (int i = 0; i < size; ++i) {
            this.listenerList.get(i).filterChanged(filter);
        }
    }

    @Override
    public boolean isActive() {
        return this.active;
    }

    @Override
    public String getActiveText() {
        return this.activeText;
    }

    @Override
    public MatcherEditor<E> getMatcherEditor() {
        return this.editor;
    }

    @Override
    public void reset() {
        this.deactivate();
    }

    protected void activate(String activeText, Matcher<E> matcher) {
        FilterInspectionUtils.filterUsed();
        this.activeText = activeText;
        this.editor.setMatcher(matcher);
        this.active = true;
    }

    protected void deactivate() {
        this.editor.setMatcher(null);
        this.activeText = null;
        this.active = false;
    }

    protected FilterResources getResources() {
        return this.resources;
    }

    private static class CloseIcon
    implements Icon {
        private static final float SIZE_TO_THICKNESS = 4.0f;
        private final Color color;
        private final int size;

        public CloseIcon(Color color, int size) {
            this.color = color;
            this.size = size;
        }

        @Override
        public int getIconHeight() {
            return this.size;
        }

        @Override
        public int getIconWidth() {
            return this.size;
        }

        @Override
        public void paintIcon(Component c, Graphics g, int x, int y) {
            Graphics2D g2d = (Graphics2D)g.create();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            float thickness = Math.max((float)this.size / 4.0f, 1.0f);
            g2d.setColor(this.color);
            g2d.setStroke(new BasicStroke(thickness));
            Line2D.Double backSlash = new Line2D.Double(0.0, 0.0, this.size, this.size);
            Line2D.Double slash = new Line2D.Double(0.0, this.size, this.size, 0.0);
            g2d.translate(x, y);
            g2d.draw(backSlash);
            g2d.draw(slash);
            g2d.dispose();
        }
    }

    public static class FilterResources {
        @Resource(key="AdvancedFilter.filterWidth")
        private int filterWidth;
        @Resource(key="AdvancedFilter.background")
        private Color background;
        @Resource(key="AdvancedFilter.headerColor")
        private Color headerColor;
        @Resource(key="AdvancedFilter.headerFont")
        private Font headerFont;
        @Resource(key="AdvancedFilter.highlightBackground")
        private Color highlightBackground;
        @Resource(key="AdvancedFilter.highlightForeground")
        private Color highlightForeground;
        @Resource(key="AdvancedFilter.rowColor")
        private Color rowColor;
        @Resource(key="AdvancedFilter.rowFont")
        private Font rowFont;
        @Resource(key="AdvancedFilter.popupBorderColor")
        private Color popupBorderColor;
        private Icon popupCloseIcon = new CloseIcon(Color.WHITE, 6);
        @Resource(key="AdvancedFilter.popupHeaderFont")
        private Font popupHeaderFont;
        @Resource(key="AdvancedFilter.popupHeaderBackground")
        private Color popupHeaderBackground;
        @Resource(key="AdvancedFilter.popupHeaderForeground")
        private Color popupHeaderForeground;

        FilterResources() {
            GuiUtils.assignResources(this);
        }

        public int getFilterWidth() {
            return this.filterWidth;
        }

        public Color getBackground() {
            return this.background;
        }

        public Color getHeaderColor() {
            return this.headerColor;
        }

        public Font getHeaderFont() {
            return this.headerFont;
        }

        public Color getHighlightBackground() {
            return this.highlightBackground;
        }

        public Color getHighlightForeground() {
            return this.highlightForeground;
        }

        public Color getPopupBorderColor() {
            return this.popupBorderColor;
        }

        public Icon getPopupCloseIcon() {
            return this.popupCloseIcon;
        }

        public Font getPopupHeaderFont() {
            return this.popupHeaderFont;
        }

        public Color getPopupHeaderBackground() {
            return this.popupHeaderBackground;
        }

        public Color getPopupHeaderForeground() {
            return this.popupHeaderForeground;
        }

        public Color getRowColor() {
            return this.rowColor;
        }

        public Font getRowFont() {
            return this.rowFont;
        }
    }
}

