/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.filter;

import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.event.ListEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.limewire.core.api.Category;
import org.limewire.ui.swing.filter.CategoryFilter;
import org.limewire.ui.swing.filter.FilterableItem;
import org.limewire.ui.swing.filter.FilterableSource;

class CategoryDetector<E extends FilterableItem> {
    private static final int RESULTS_COUNT = 25;
    private static final int TIMER_DELAY = 10000;
    private final FilterableSource<E> filterableSource;
    private final CategoryFilter categoryFilter;
    private CategoryDetectorListener detectorListener;
    private ListEventListener<E> resultsListener;
    private ActionListener timerListener;
    private Timer timer;

    public CategoryDetector(FilterableSource<E> filterableSource, CategoryFilter categoryFilter) {
        this.filterableSource = filterableSource;
        this.categoryFilter = categoryFilter;
    }

    public void start(CategoryDetectorListener listener) {
        this.detectorListener = listener;
        this.resultsListener = new ListEventListener<E>(){

            @Override
            public void listChanged(ListEvent listChanges) {
                int size = listChanges.getSourceList().size();
                if (size >= 25) {
                    CategoryDetector.this.fireDelayedCategoryFound();
                }
            }
        };
        this.filterableSource.getUnfilteredList().addListEventListener(this.resultsListener);
        this.timerListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CategoryDetector.this.fireDelayedCategoryFound();
            }
        };
        this.timer = new Timer(10000, this.timerListener);
        this.timer.start();
    }

    public void stop() {
        if (this.resultsListener != null) {
            this.filterableSource.getUnfilteredList().removeListEventListener(this.resultsListener);
            this.resultsListener = null;
        }
        if (this.timer != null) {
            this.timer.stop();
            this.timer.removeActionListener(this.timerListener);
            this.timerListener = null;
            this.timer = null;
        }
    }

    private void fireDelayedCategoryFound() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (CategoryDetector.this.detectorListener != null) {
                    Category category = CategoryDetector.this.categoryFilter.getDefaultCategory();
                    CategoryDetector.this.detectorListener.categoryFound(category);
                    CategoryDetector.this.detectorListener = null;
                }
            }
        });
        this.stop();
    }

    public static interface CategoryDetectorListener {
        public void categoryFound(Category var1);
    }
}

