/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.friends.chat;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.Timer;
import org.jdesktop.beans.AbstractBean;
import org.limewire.friend.api.Friend;
import org.limewire.friend.api.FriendPresence;
import org.limewire.friend.api.MessageReader;
import org.limewire.friend.api.MessageWriter;
import org.limewire.friend.api.feature.LimewireFeature;
import org.limewire.ui.swing.friends.chat.ChatFriend;
import org.limewire.ui.swing.util.SwingUtils;

class ChatFriendImpl
extends AbstractBean
implements ChatFriend {
    private boolean chatting;
    private final Friend friend;
    private String status;
    private FriendPresence.Mode mode;
    private long chatStartTime;
    private boolean hasUnviewedMessages;
    private Timer timer;
    private int flashCount = 0;

    ChatFriendImpl(FriendPresence presence) {
        this.friend = presence.getFriend();
        this.status = presence.getStatus();
        this.mode = presence.getMode();
    }

    @Override
    public Friend getFriend() {
        return this.friend;
    }

    @Override
    public String getID() {
        return this.friend.getId();
    }

    @Override
    public FriendPresence.Mode getMode() {
        return this.mode;
    }

    void setMode(FriendPresence.Mode mode) {
        FriendPresence.Mode oldMode = this.getMode();
        this.mode = mode;
        this.firePropertyChange("mode", (Object)oldMode, (Object)mode);
    }

    @Override
    public String getName() {
        return this.friend.getRenderName();
    }

    @Override
    public String getStatus() {
        return this.status;
    }

    void setStatus(String status) {
        String oldStatus = this.getStatus();
        this.status = status;
        this.firePropertyChange("status", oldStatus, status);
    }

    @Override
    public boolean isChatting() {
        return this.chatting;
    }

    void setChatting(final boolean chatting) {
        final boolean oldChatting = this.isChatting();
        this.chatting = chatting;
        SwingUtils.invokeNowOrLater(new Runnable(){

            @Override
            public void run() {
                ChatFriendImpl.this.firePropertyChange("chatting", oldChatting, chatting);
            }
        });
    }

    @Override
    public MessageWriter createChat(MessageReader reader) {
        return this.friend.createChat(reader);
    }

    @Override
    public void startChat() {
        if (!this.isChatting()) {
            this.chatStartTime = System.currentTimeMillis();
            this.setChatting(true);
        }
    }

    @Override
    public void update() {
        FriendPresence presence = this.getPresenceForModeAndStatus();
        if (presence != null) {
            this.setStatus(presence.getStatus());
            this.setMode(presence.getMode());
        }
    }

    @Override
    public void stopChat() {
        this.stopTimer();
        this.setChatting(false);
        this.setHasUnviewedMessages(false);
    }

    @Override
    public long getChatStartTime() {
        return this.chatStartTime;
    }

    @Override
    public boolean isSignedInToLimewire() {
        for (FriendPresence presence : this.friend.getPresences().values()) {
            if (presence.getFeature(LimewireFeature.ID) == null) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isSignedIn() {
        return this.friend.isSignedIn();
    }

    @Override
    public boolean hasUnviewedMessages() {
        return this.hasUnviewedMessages;
    }

    @Override
    public boolean isFlashState() {
        return this.flashCount % 2 == 0;
    }

    @Override
    public void setHasUnviewedMessages(boolean hasMessages) {
        if (hasMessages) {
            this.startTimer();
        } else {
            this.stopTimer();
        }
        boolean oldHasUnviewedMessages = this.hasUnviewedMessages;
        this.hasUnviewedMessages = hasMessages;
        this.firePropertyChange("receivingUnviewedMessages", oldHasUnviewedMessages, hasMessages);
    }

    private void startTimer() {
        if (this.timer == null) {
            this.timer = new Timer(1500, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    if (ChatFriendImpl.this.flashCount > 4) {
                        ChatFriendImpl.this.stopTimer();
                    }
                    ChatFriendImpl.this.firePropertyChange("flashIncrement", ChatFriendImpl.this.flashCount, ChatFriendImpl.this.flashCount + 1);
                    ChatFriendImpl.this.flashCount += 1;
                }
            });
            this.timer.start();
        } else {
            this.flashCount = 0;
            this.timer.restart();
        }
    }

    private void stopTimer() {
        if (this.timer != null) {
            this.timer.stop();
            this.flashCount = 0;
            this.timer = null;
        }
    }

    private FriendPresence getPresenceForModeAndStatus() {
        ArrayList<FriendPresence> presences = new ArrayList<FriendPresence>(this.friend.getPresences().values());
        Collections.sort(presences, new ModeAndPriorityPresenceComparator());
        return presences.size() == 0 ? null : presences.get(presences.size() - 1);
    }

    private static class ModeAndPriorityPresenceComparator
    implements Comparator<FriendPresence> {
        private ModeAndPriorityPresenceComparator() {
        }

        @Override
        public int compare(FriendPresence o1, FriendPresence o2) {
            if (!o1.getMode().equals((Object)o2.getMode())) {
                if (o1.getMode() == FriendPresence.Mode.available) {
                    return 1;
                }
                if (o2.getMode() == FriendPresence.Mode.available) {
                    return -1;
                }
            }
            return Integer.valueOf(o1.getPriority()).compareTo(o2.getPriority());
        }
    }
}

