/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.friends.chat;

import ca.odell.glazedlists.BasicEventList;
import ca.odell.glazedlists.EventList;
import com.google.inject.Inject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.limewire.friend.api.Friend;
import org.limewire.friend.api.FriendPresence;
import org.limewire.friend.api.FriendPresenceEvent;
import org.limewire.friend.api.IncomingChatListener;
import org.limewire.friend.api.MessageReader;
import org.limewire.friend.api.MessageWriter;
import org.limewire.inject.LazySingleton;
import org.limewire.listener.EventBroadcaster;
import org.limewire.listener.EventListener;
import org.limewire.listener.ListenerSupport;
import org.limewire.listener.SwingEDTEvent;
import org.limewire.ui.swing.friends.chat.ChatFriend;
import org.limewire.ui.swing.friends.chat.ChatFriendImpl;
import org.limewire.ui.swing.friends.chat.ChatMessageEvent;
import org.limewire.ui.swing.friends.chat.ChatStateEvent;
import org.limewire.ui.swing.friends.chat.IncomingListener;
import org.limewire.ui.swing.friends.chat.MessageReaderImpl;
import org.limewire.ui.swing.friends.chat.MessageWriterImpl;
import org.limewire.ui.swing.util.SwingUtils;

@LazySingleton
class ChatModel {
    private final EventList<ChatFriend> chatFriends;
    private final Map<String, ChatFriend> idToFriendMap;
    private final ListenerSupport<FriendPresenceEvent> presenceSupport;
    private PresenceListener presenceEvent;
    private final List<IncomingListener> incomingListeners = new CopyOnWriteArrayList<IncomingListener>();
    private final EventBroadcaster<ChatMessageEvent> chatMessageList;
    private final EventBroadcaster<ChatStateEvent> chatStateList;

    @Inject
    public ChatModel(ListenerSupport<FriendPresenceEvent> presenceSupport, EventBroadcaster<ChatMessageEvent> chatMessageList, EventBroadcaster<ChatStateEvent> chatStateList) {
        this.presenceSupport = presenceSupport;
        this.chatFriends = new BasicEventList<ChatFriend>();
        this.idToFriendMap = new HashMap<String, ChatFriend>();
        this.chatStateList = chatStateList;
        this.chatMessageList = chatMessageList;
    }

    public EventList<ChatFriend> getChatFriendList() {
        return this.chatFriends;
    }

    public ChatFriend getChatFriend(String friendId) {
        return this.idToFriendMap.get(friendId);
    }

    public void addIncomingListener(IncomingListener listener) {
        this.incomingListeners.add(listener);
    }

    public void removeIncomingListener(IncomingListener listener) {
        this.incomingListeners.remove(listener);
    }

    public void registerListeners() {
        if (this.presenceEvent == null) {
            this.presenceEvent = new PresenceListener();
        }
        this.presenceSupport.addListener(this.presenceEvent);
    }

    public void unregisterListeners() {
        if (this.presenceEvent != null) {
            this.presenceSupport.removeListener(this.presenceEvent);
        }
        this.idToFriendMap.clear();
        this.chatFriends.clear();
    }

    void handlePresenceEvent(FriendPresenceEvent event) {
        FriendPresence presence = (FriendPresence)event.getData();
        Friend friend = presence.getFriend();
        ChatFriend chatFriend = this.idToFriendMap.get(friend.getId());
        switch ((FriendPresenceEvent.Type)((Object)event.getType())) {
            case ADDED: {
                this.addFriend(chatFriend, presence);
                break;
            }
            case UPDATE: {
                if (chatFriend == null) break;
                chatFriend.update();
                break;
            }
            case REMOVED: {
                if (chatFriend == null) break;
                this.removeFriendIfNecessary(chatFriend);
                chatFriend.update();
            }
        }
    }

    public void removeFriendIfNecessary(ChatFriend chatFriend) {
        if (this.shouldRemoveFromFriendsList(chatFriend)) {
            Friend friend = chatFriend.getFriend();
            this.chatFriends.remove(this.idToFriendMap.remove(friend.getId()));
            friend.removeChatListener();
        }
    }

    private boolean shouldRemoveFromFriendsList(ChatFriend chatFriend) {
        return !chatFriend.isChatting() && !chatFriend.isSignedIn();
    }

    private void addFriend(ChatFriend chatFriend, FriendPresence presence) {
        if (chatFriend == null) {
            chatFriend = new ChatFriendImpl(presence);
            this.chatFriends.add(chatFriend);
            this.idToFriendMap.put(presence.getFriend().getId(), chatFriend);
        }
        final ChatFriend friend = chatFriend;
        IncomingChatListener incomingChatListener = new IncomingChatListener(){

            @Override
            public MessageReader incomingChat(final MessageWriter writer) {
                SwingUtils.invokeNowOrWait(new Runnable(){

                    @Override
                    public void run() {
                        MessageWriterImpl writerWrapper = new MessageWriterImpl(friend, writer, ChatModel.this.chatMessageList);
                        ChatModel.this.fireIncomingEvent(friend, writerWrapper);
                    }
                });
                return new MessageReaderImpl(friend, ChatModel.this.chatMessageList, ChatModel.this.chatStateList);
            }
        };
        presence.getFriend().setChatListenerIfNecessary(incomingChatListener);
        chatFriend.update();
    }

    private void fireIncomingEvent(ChatFriend chatFriend, MessageWriter messageWriter) {
        for (IncomingListener listener : this.incomingListeners) {
            listener.incomingChat(chatFriend, messageWriter);
        }
    }

    private class PresenceListener
    implements EventListener<FriendPresenceEvent> {
        private PresenceListener() {
        }

        @Override
        @SwingEDTEvent
        public void handleEvent(FriendPresenceEvent event) {
            ChatModel.this.handlePresenceEvent(event);
        }
    }
}

