/*
 * Decompiled with CFR 0.152.
 */
package org.limewire.ui.swing.library.table;

import com.google.inject.Provider;
import java.awt.Component;
import java.awt.Point;
import java.util.Collections;
import java.util.List;
import org.limewire.core.api.library.LocalFileItem;
import org.limewire.ui.swing.library.table.LibraryPopupMenu;
import org.limewire.ui.swing.library.table.LibraryTable;
import org.limewire.ui.swing.table.TablePopupHandler;

class LibraryPopupHandler
implements TablePopupHandler {
    private final LibraryTable libraryTable;
    private final Provider<LibraryPopupMenu> popupMenu;

    public LibraryPopupHandler(LibraryTable libraryTab, Provider<LibraryPopupMenu> popupMenu) {
        this.libraryTable = libraryTab;
        this.popupMenu = popupMenu;
    }

    @Override
    public boolean isPopupShowing(int row) {
        return false;
    }

    @Override
    public void maybeShowPopup(Component component, int x, int y) {
        int popupRow = this.libraryTable.rowAtPoint(new Point(x, y));
        if (popupRow < 0) {
            return;
        }
        LocalFileItem selectedItem = (LocalFileItem)this.libraryTable.getModel().getValueAt(popupRow, 0);
        List<LocalFileItem> selectedItems = Collections.unmodifiableList(this.libraryTable.getSelection());
        if (selectedItems.size() <= 1 || !selectedItems.contains(selectedItem)) {
            this.libraryTable.setRowSelectionInterval(popupRow, popupRow);
        }
        this.popupMenu.get().show(component, x, y);
    }
}

